C
C =====================================================================
C ======================== M A T M O D ================================
C =====================================================================
C
      SUBROUTINE MATMOD(ELNUM,ELEM_TYPE,MATNUM,INTGPN,STRS_STRN_REL,
     .                  I_OUT,EVAL_STIFF_OR_EVAL_STRESS)
      IMPLICIT NONE
      INTEGER MAT_ELAS,MAT_PLAS,MAT_ELAS_DAM,MAT_PLAS_DAM
      INTEGER MAX_MAT_TYPE
      INTEGER STRS_STRN_REL,PLANE_STRESS,PLANE_STRAIN,AXISYMMETRIC
      INTEGER EVAL_STIFF_OR_EVAL_STRESS,EVAL_STIFF,EVAL_STRESS
      PARAMETER (EVAL_STIFF=0,EVAL_STRESS=1)
      PARAMETER (PLANE_STRESS=1,PLANE_STRAIN=2,AXISYMMETRIC=3)
      PARAMETER (MAT_ELAS=1,MAT_PLAS=2,MAT_ELAS_DAM=3,MAT_PLAS_DAM=4)
      PARAMETER (MAX_MAT_TYPE=10)
      INTEGER ELNUM,ELEM_TYPE,I,INTGPN,I_OUT,MATNUM,MATYPE
      COMMON/INPUTF/MATYPE(MAX_MAT_TYPE)
C
      I = MATYPE( MATNUM )
      IF (I.EQ.MAT_ELAS) THEN
        CALL ELAST(ELEM_TYPE,MATNUM,STRS_STRN_REL,I_OUT,
     .             EVAL_STIFF_OR_EVAL_STRESS)
      ELSE IF(I.EQ.MAT_PLAS) THEN
        CALL PLAST(ELNUM,ELEM_TYPE,MATNUM,INTGPN,STRS_STRN_REL,I_OUT,
     .             EVAL_STIFF_OR_EVAL_STRESS)
      ELSE IF(I.EQ.MAT_ELAS_DAM) THEN
        CALL ELDAM(ELNUM,ELEM_TYPE,MATNUM,INTGPN,STRS_STRN_REL,I_OUT,
     .             EVAL_STIFF_OR_EVAL_STRESS)
      ELSE IF(I.EQ.MAT_PLAS_DAM) THEN
        CALL PLDAM(ELNUM,ELEM_TYPE,MATNUM,INTGPN,STRS_STRN_REL,I_OUT,
     .             EVAL_STIFF_OR_EVAL_STRESS)
      ELSE
        WRITE (I_OUT , 100) I
        STOP 'INVALID MATERIAL TYPE SPECIFIED'
      END IF
 100  FORMAT (/1X,'INVALID MATERIAL TYPE(',I3,') SPECIFIED')
C
      END
C
C =====================================================================
C ======================= E L A S T ===================================
C =====================================================================
C
      SUBROUTINE ELAST(ELEM_TYPE,MATNUM,STRS_STRN_REL,I_OUT,
     .                 EVAL_STIFF_OR_EVAL_STRESS)
      IMPLICIT NONE
      INTEGER STRS_STRN_REL
      INTEGER EVAL_STIFF_OR_EVAL_STRESS,EVAL_STIFF
      PARAMETER (EVAL_STIFF=0)
      INTEGER ELEM_TYPE,MATNUM,I_OUT
C
      IF (EVAL_STIFF_OR_EVAL_STRESS.EQ.EVAL_STIFF) THEN
        CALL DELAST(ELEM_TYPE,MATNUM,STRS_STRN_REL)
      ELSE
        CALL STRSTN(ELEM_TYPE,MATNUM,STRS_STRN_REL)
      END IF
C
      END
C
C =====================================================================
C ======================= S T R S T N =================================
C =====================================================================
C
      SUBROUTINE STRSTN(ELEM_TYPE,MATNUM,STRS_STRN_REL)
      IMPLICIT NONE
      INTEGER STRS_STRN_REL
      INTEGER ELEM_TYPE,INCREM,K1,K2,LDEV,LDEV1,LDEV2,LDEV3,LDEV4
      INTEGER LDEVST,MATNUM,NIT,IEND
      REAL*8 S,DEP,STRN,STRS,STRESS(6),STRAIN(6),DE(6),DS(6),ZERO
      COMMON/MATER1/DEP(6,6)
      COMMON/ELSTR1/STRN(6)
      COMMON/ELSTR2/STRS(6)
      COMMON/DEVICE/LDEV1,LDEV2,LDEV3,LDEV4,LDEV,LDEVST
      COMMON/CONTR1/INCREM,NIT
C
      DATA ZERO /0.0D0/
C
      IF(ELEM_TYPE.GT.300) THEN
        IEND=6
      ELSE
        IEND=4
      ENDIF
      IF (INCREM.GT.1) THEN
        READ(LDEV1) STRESS,STRAIN
      ELSE
        DO K1 = 1 , IEND
          STRESS( K1 ) = ZERO
          STRAIN( K1 ) = ZERO
        END DO
      END IF
      DO K1 = 1 , IEND
        DE( K1 ) = STRN( K1 ) - STRAIN( K1 )
      END DO
      CALL DELAST(ELEM_TYPE,MATNUM,STRS_STRN_REL)
      DO K1= 1 , IEND
        S = ZERO
        DO K2 = 1 , IEND
          S = S + DEP(K1 , K2)*DE( K2 )
        END DO
        DS( K1 ) = S
      END DO
      DO K1=1,IEND
        STRAIN(K1)=STRN(K1)
        STRESS(K1)=STRESS(K1)+DS(K1)
        STRS(K1)=STRESS(K1)
      END DO
      WRITE(LDEV2) STRESS,STRAIN
C
      END
C
C =====================================================================
C ====================== D E L A S T ==================================
C =====================================================================
C
      SUBROUTINE DELAST(ELEM_TYPE,MATNUM,STRS_STRN_REL)
C
C =====================================================================
C I                                                                   I
C I   PROGRAM 'DELAST'EVALUATES THE STRESS-STRAIN STIFFNESS MATRIX    I
C I   FOR ISOTROPIC OR ORTHOTROPIC ELASTIC MATERIALS                  I
C I                                                                   I
C I   C O M M O N      B L O C K S                                    I
C I                                                                   I
C I                                                                   I
C =====================================================================
C
      IMPLICIT NONE
      INTEGER MAX_MAT_TYPE
      INTEGER STRS_STRN_REL,PLANE_STRESS
      PARAMETER (PLANE_STRESS=1)
      PARAMETER (MAX_MAT_TYPE=10)
      INTEGER ELEM_TYPE,MATNUM,P2X
      REAL*8 NUX,NUY,NUZ,LAMBDA,MU,DEP,EX,EY,EZ,P1X,P1Y,P1Z
      REAL*8 P2Y,P2Z,HALF,ONE,TWO,CST1
      COMMON/MATER1/DEP(6,6)
      COMMON/INPUT5/NUX(MAX_MAT_TYPE),NUY(MAX_MAT_TYPE),
     .              NUZ(MAX_MAT_TYPE),EX(MAX_MAT_TYPE),
     .              EY(MAX_MAT_TYPE),EZ(MAX_MAT_TYPE),
     .              P1X(MAX_MAT_TYPE),P1Y(MAX_MAT_TYPE),
     .              P1Z(MAX_MAT_TYPE),P2X(MAX_MAT_TYPE),
     .              P2Y(MAX_MAT_TYPE),P2Z(MAX_MAT_TYPE)
C
      DATA HALF,ONE,TWO /0.5D0,1.0D0,2.0D0/
C
      CALL DIARRAY(DEP,6,6,0,0,0,0,0)
      MU=HALF*EX(MATNUM)/(ONE+NUX(MATNUM))
      LAMBDA=(NUX(MATNUM)*EX(MATNUM))/((ONE+NUX(MATNUM))*
     .       (ONE-TWO*NUX(MATNUM)))
      IF (ELEM_TYPE.GT.300) THEN
        DEP(1 , 1) = LAMBDA+TWO*MU
        DEP(2 , 2) = LAMBDA+TWO*MU
        DEP(3 , 3) = LAMBDA+TWO*MU
        DEP(4 , 4) = MU
        DEP(5 , 5) = MU
        DEP(6 , 6) = MU
        DEP(1 , 2) = LAMBDA
        DEP(1 , 3) = LAMBDA
        DEP(2 , 1) = LAMBDA
        DEP(2 , 3) = LAMBDA
        DEP(3 , 1) = LAMBDA
        DEP(3 , 2) = LAMBDA
      ELSE
C
C       PLANE STRESS
C
        IF (STRS_STRN_REL.EQ.PLANE_STRESS) THEN
          DEP(1,1)=EX(MATNUM)/(ONE-NUX(MATNUM)**2)
          DEP(2,2)=DEP(1,1)
          DEP(3,3)=EX(MATNUM)*HALF/(ONE+NUX(MATNUM))
          DEP(1,2)=NUX( MATNUM )*DEP(1 , 1)
          DEP(2,1)=DEP(1 , 2)
C
C       AXISYMMETRIC AND PLANE STRAIN
C
        ELSE
          CST1=EX(MATNUM)/(ONE+NUX(MATNUM))/(ONE-TWO*NUX(MATNUM))
          DEP(1 , 1) = (ONE-NUX(MATNUM))*CST1
          DEP(2 , 2) = DEP(1 , 1)
          DEP(3 , 3) = EX(MATNUM)*HALF/(ONE+NUX(MATNUM))
          DEP(4 , 4) = DEP(1 , 1)
          DEP(1 , 2) = NUX( MATNUM )*CST1
          DEP(2 , 1) = NUX( MATNUM )*CST1
          DEP(1 , 4) = NUX( MATNUM )*CST1
          DEP(4 , 1) = NUX( MATNUM )*CST1
          DEP(2 , 4) = NUX( MATNUM )*CST1
          DEP(4 , 2) = NUX( MATNUM )*CST1
        END IF
      END IF
C
      END
C
C
C =====================================================================
C ===========               S T A R T   O F                   =========
C =========== L I N E A R    E L A S T I C I T Y    M O D E L =========
C ===========   W I T H    D A M A G E    M E C H A N I C S   =========
C =====================================================================
C ======================== E L D A M ==================================
C =====================================================================
      SUBROUTINE ELDAM(ELNUM,ITYPE,MATNUM,INTGPN,IFLAG,IOUT,ICODE)
      INTEGER ELNUM
C
      IF (ICODE.EQ.0) THEN
        CALL DELDAM(ITYPE,MATNUM,IFLAG,IOUT,IEND)
      ELSE
        CALL STRDAM(ELNUM,ITYPE,MATNUM,INTGPN,IFLAG,IOUT,IEND)
      END IF
C
      RETURN
      END
C =====================================================================
C ======================== M E D A M ==================================
C =====================================================================
      SUBROUTINE MEDAM
C =====================================================================
C I                                                                   I
C I   P R O G R A M:                                                  I
C I                                                                   I
C I      PROGRAM 'MEDAM' IS THE CONTROL UNIT FOR CALCULATION OF THE   I
C I      ELASTIC STRESS-STRAIN STIFFNESS MATRIX INCLUDING THE         I
C I      EFFECT OF DAMAGE.                                            I
C I                                                                   I
C =====================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      REAL*8 NUX,NUY,NUZ
      CHARACTER*48 CSTRN,CSTRS,CSELA,CPHI,CCENT
      CHARACTER*8 CWORK
      CHARACTER*1 IYIELD,IY
      INTEGER ELNUM
      COMMON/DEV1/LDEV5,LDEV6,LDEV7,LDEV8,LDEV9,LDEV10
      COMMON/DEVICE/LDEV1,LDEV2,LDEV3,LDEV4,LDEV,LDEVST
      COMMON/CONTR1/INCREM,NIT
      COMMON/ELSTR1/STRN(6)
      COMMON/ELSTR2/STRS(6)
      COMMON/ADMAT1/AD(3,3,3,3)
      COMMON/PLAST1/IYIEL(400)
C     COMMON/FDER1/FJ,FK,FS(3,3),FE(3,3),FZ(3,3),FT(3,3)
      COMMON/MATER1/DEP(6,6)
      COMMON/EDBAR1/EDIJKL(3,3,3,3)
      COMMON/INPUT8/NNODES,NELEM,NNDF,NLINC,MNIT,IFLAG1,IFLAG2,IDIM,
     1              NINODE
      COMMON/INPUT5/NUX(10),NUY(10),NUZ(10),EX(10),EY(10),EZ(10),P1X(10)
     1              ,P1Y(10),P1Z(10),P2X(10),P2Y(10),P2Z(10)
      COMMON/INPUTJ/P3X(10),P4X(10),P5X(10)
      COMMON/GDER1/GS(3,3),GPHI(3,3)
      DIMENSION S0(3,3),E(3,3),ED(3,3),STRELA(6),
     1          SF(3,3),DELAS(6),SS(6),
     2          STRESS(6),STRAIN(6),DE(6),SDOT(3,3)
      DIMENSION PHI(6),DAMVAR(3,3),ABET(3,3),DDAMVA(3,3)
      EQUIVALENCE (CSTRS,STRESS),(CSTRN,STRAIN),(CPHI,PHI),
     1            (CSELA,STRELA)
C
C     DATA ((DEL(K1,K2),K1=1,3),K2=1,3)/1.,0.,0.,0.,1.,0.,0.,0.,1./
C
C ====================ENTRY STRDAM ================================
C
      ENTRY STRDAM(ELNUM,ITYPE,MATNUM,INTGPN,IFLAG,IOUT,IEND)
C
      IF (INCREM.GT.1) THEN
        READ(LDEV1,1000) CSTRS,CSTRN,CSELA,CPHI
      ELSE
           DO 10 K1 = 1 , 6
           STRAIN( K1 ) = 0.D0
           STRESS( K1 ) = 0.D0
           STRELA( K1 ) = 0.D0
  10       PHI( K1 ) = 0.D0
           ABETA = 0.D0
      END IF
C
C --- GET THE MATERIAL PARAMETERS
C
      DAMA = P3X(MATNUM)
      DBBET=P5X(MATNUM)
      YOUNG = EX( MATNUM )
      POISS = NUX( MATNUM )
      YP=(POISS*YOUNG)/((POISS*YOUNG)+3.D0*(1.D0-2.D0*POISS))
C
C --- CALCULATION OF THE STRAIN INCREMENT
C
      DO 20 K1 = 1 , 3
  20  DE( K1 ) = STRN( K1 ) - STRAIN( K1 )
      STRN(4)=-YP*(STRN(1)+STRN(2))
      DE(4)=-YP*(DE(1)+DE(2))
C
C --- CALCULATION OF THE USEFULL TENSORS
C
      CALL TENSOR(ITYPE,STRESS,S0,1.D0)
      CALL TENSOR(ITYPE,STRAIN,E,0.5D0)
      CALL TENSOR(ITYPE,DE,ED,0.5D0)
      CALL TENSOR(300,PHI,DAMVAR,1.D0)
C
C --- CALCULATION OF THE FOURTH ORDER ELASTIC STIFFNESS MATRIX
C
      CALL ADMAT(YOUNG,POISS)
      CALL JIJKL(DAMA)
      CALL AMIJK(PHI)
      CALL AMINV
      CALL EDBAR
C
      DO 55 K1=1,3
      CST=0.D0
      DO 40 K2=1,3
 40   CST=CST+DEP(K1,K2)*DE(K2)
 55   SS(K1)=CST
      SS(4)=0.D0
      SS(5)=0.D0
      SS(6)=0.D0
C
      CALL TENSOR(ITYPE,SS,SDOT,1.D0)
C
C --- START OF THE INCREMENTATION LOOP
C --- CALCULATION OF THE TRIAL ELASTIC STRESS
C
      DO 35 K2 = 1 , 3
      DO 35 K1 = 1 , 3
  35  SF(K1 , K2) = S0(K1 , K2) + SDOT(K1 , K2)
C
      DO 65 K2=1,3
      DO 65 K1=1,3
      E(K1,K2)=E(K1,K2)+ED(K1,K2)
 65   S0(K1,K2)=SF(K1,K2)
C
      S0(3,3)=0.D0
      CALL MDPHI(PHI)
      CALL GDER(S0)
C
      ABETA = 0.D0
      CST1=0.0
      DO 69 K1=1,3
      DO 69 K2=1,3
      CST1=CST1+GPHI(K1,K2)*GS(K1,K2)
   69 CONTINUE
C
      DO 66 K3=1,3
      DO 66 K4=1,3
      ABET(K3,K4)=0.D0
      DO 66 K1=1,3
      DO 66 K2=1,3
      ABET(K3,K4)=ABET(K3,K4)
     $+(GS(K1,K2)*EDIJKL(K1,K2,K3,K4))/(DBBET-CST1)
   66 CONTINUE
C
      DO 70 K2 = 1 , 3
      DO 70 K1 = 1 , 3
   70 ABETA=ABETA+ABET(K1,K2)*ED(K1,K2)
C
      DO 80 K2=1,3
      DO 80 K1=1,3
      DDAMVA(K1,K2)=ABETA*GS(K1,K2)
   80 IF(DDAMVA(K1,K2).LT.0.) DDAMVA(K1,K2)=0.D0
C
      DO 88 K1=1,3
      DO 88 K2=1,3
   88 DAMVAR(K1,K2)=DAMVAR(K1,K2)+DDAMVA(K1,K2)
C
      DO 120 K1 = 1 , 3
 120  STRAIN( K1 ) = STRN( K1 )
      STRN(4)=STRAIN(4)+DE(4)
      STRAIN(4)=STRN(4)
C
      DO 130 K1 = 1 , 6
 130  STRELA(K1)=STRN(K1)
C
      DAMVAR(1,3)=0.D0
      DAMVAR(2,3)=0.D0
      DAMVAR(3,1)=0.D0
      DAMVAR(3,2)=0.D0
      DAMVAR(3,3)=0.D0
C
      CALL VECTOR(ITYPE,S0,STRS,1.D0)
      CALL VECTOR(ITYPE,S0,STRESS,1.D0)
      CALL VECTOR(300,DAMVAR,PHI,1.D0)
C
      WRITE(LDEV2,1000)CSTRS,CSTRN,CSELA,CPHI
C
      RETURN
C
C ===================== ENTRY DELDAM ================================
C
      ENTRY DELDAM(ITYPE,MATNUM,IFLAG,IOUT,IEND)
C
      IF (INCREM.GT.1) THEN
         IF (NIT.EQ.1) THEN
           READ(LDEV1,1000) CSTRS,CSTRN,CSELA,CPHI
           ELSE
           READ(LDEV2,1000) CSTRS,CSTRN,CSELA,CPHI
           END IF
           BACKSPACE(UNIT=LDEV)
      END IF
C
C --- CALCULATION OF THE USEFULL MATRICES
C
C          PHI(3)=0.D0
           CALL TENSOR(ITYPE,STRESS,S0,1.D0)
           CALL TENSOR(ITYPE,STRAIN,E,0.5D0)
           CALL TENSOR(300,PHI,DAMVAR,1.D0)
C          S0(3,3)=0.D0
C
C --- GET THE MATERIAL PARAMETERS
C
           DAMA = P3X(MATNUM)
           DBBET=P5X(MATNUM)
           YOUNG = EX( MATNUM )
           POISS = NUX( MATNUM )
C
C --- CALCULATION OF THE FOURTH ORDER ELASTIC STIFFNESS MATRIX
C
           CALL ADMAT(YOUNG,POISS)
           CALL AMIJK(PHI)
           CALL AMINV
           CALL EDBAR
           CALL CONVER(EDIJKL,DEP,IFLAG,ITYPE)
C     IF (DEP(1,3).LT.0.0) THEN
C     DEP(1,3)=0.D0
C     DEP(3,1)=0.D0
C     END IF
C
C     IF (DEP(2,3).LT.0.0) THEN
C     DEP(2,3)=0.D0
C     DEP(3,2)=0.D0
C     END IF
C
      RETURN
 1000 FORMAT(4A48)
      END
C
C =====================================================================
C =======================  E D B A R ==================================
C =====================================================================
C
      SUBROUTINE EDBAR
C
C THIS SUBPROGRAM CALCULATES THE MODIFIED ELASTO-PLASTIC STIFFNESS
C MATRIX TO INCLUDE THE EFFECT OF DAMAGE
C
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON/AMINV1/XMTINV(3,3,3,3)
      COMMON/ADMAT1/AD(3,3,3,3)
      COMMON/EDBAR1/EDIJKL(3,3,3,3)
      DIMENSION CST(3,3,3,3)
C
      DO 10 M=1,3
      DO 10 N=1,3
      DO 10 K=1,3
      DO 10 L=1,3
      CST(M,N,K,L)=0.D0
      DO 10 I=1,3
      DO 10 J=1,3
      CST(M,N,K,L)=CST(M,N,K,L)+XMTINV(I,J,M,N)*AD(I,J,K,L)
   10 CONTINUE
C
      DO 20 I=1,3
      DO 20 J=1,3
      DO 20 M=1,3
      DO 20 N=1,3
      EDIJKL(I,J,M,N)=0.D0
      DO 20 K=1,3
      DO 20 L=1,3
      EDIJKL(I,J,M,N)=EDIJKL(I,J,M,N)+CST(I,J,K,L)
     $ *XMTINV(K,L,M,N)
   20      CONTINUE
C
      RETURN
      END
C
C =====================================================================
C ======================= A M I J K ===================================
C =====================================================================
      SUBROUTINE AMIJK(PHI)
C
C THIS SUBPROGRAM CALCULATES THE DAMAGE EFFECT TENSOR M(I,J,K,L)
C
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON/AMIJK1/XMIJKL(3,3,3,3)
      DIMENSION PHI(6)
      CST1=1.D0-PHI(1)
      CST2=1.D0-PHI(2)
      CST3=1.D0-PHI(3)
      CST4=PHI(5)*PHI(5)*CST1
      CST5=PHI(6)*PHI(6)*CST2
      CST6=PHI(4)*PHI(4)*CST3
      CST7=2.D0*PHI(4)*PHI(5)*PHI(6)
      DELTA=CST1*CST2*CST3-CST4-CST5-CST6-CST7
      XMIJKL(1,1,1,1)=(CST2*CST3-PHI(5)*PHI(5))/DELTA
      XMIJKL(1,1,1,3)=(PHI(4)*PHI(5)+PHI(6)*CST2)/(2.D0*DELTA)
      XMIJKL(1,1,3,1)=XMIJKL(1,1,1,3)
      XMIJKL(3,1,1,1)=XMIJKL(1,1,1,3)
      XMIJKL(1,3,1,1)=XMIJKL(1,1,1,3)
      XMIJKL(1,1,1,2)=(PHI(6)*PHI(5)+PHI(4)*CST3)/(2.D0*DELTA)
      XMIJKL(1,1,2,1)=XMIJKL(1,1,1,2)
      XMIJKL(1,2,1,1)=XMIJKL(1,1,1,2)
      XMIJKL(2,1,1,1)=XMIJKL(1,1,1,2)
      XMIJKL(2,2,2,2)=(CST1*CST3-PHI(6)*PHI(6))/DELTA
      XMIJKL(2,2,2,3)=(PHI(4)*PHI(6)+PHI(5)*CST1)/(2.D0*DELTA)
      XMIJKL(2,2,3,2)=XMIJKL(2,2,2,3)
      XMIJKL(2,3,2,2)=XMIJKL(2,2,2,3)
      XMIJKL(3,2,2,2)=XMIJKL(2,2,2,3)
      XMIJKL(2,2,1,2)=XMIJKL(1,1,1,2)
      XMIJKL(2,2,2,1)=XMIJKL(2,2,1,2)
      XMIJKL(1,2,2,2)=XMIJKL(2,2,1,2)
      XMIJKL(2,1,2,2)=XMIJKL(2,2,1,2)
      XMIJKL(3,3,3,3)=(CST1*CST2-PHI(4)*PHI(4))/DELTA
      XMIJKL(3,3,2,3)=XMIJKL(2,2,2,3)
      XMIJKL(3,3,3,2)=XMIJKL(3,3,2,3)
      XMIJKL(2,3,3,3)=XMIJKL(3,3,2,3)
      XMIJKL(3,2,3,3)=XMIJKL(3,3,2,3)
      XMIJKL(3,3,1,3)=XMIJKL(1,1,1,3)
      XMIJKL(3,3,3,1)=XMIJKL(3,3,1,3)
      XMIJKL(3,1,3,3)=XMIJKL(3,3,1,3)
      XMIJKL(1,3,3,3)=XMIJKL(3,3,1,3)
      XMIJKL(2,3,2,3)=(CST1*CST3+CST1*CST2-PHI(6)*PHI(6)-PHI(4)*PH
     *I(4))/(4.D0*DELTA)
      XMIJKL(2,3,3,2)=XMIJKL(2,3,2,3)
      XMIJKL(3,2,2,3)=XMIJKL(2,3,2,3)
      XMIJKL(3,2,3,2)=XMIJKL(2,3,2,3)
      XMIJKL(2,3,1,3)=(PHI(6)*PHI(5)+PHI(4)*CST3)/(4.D0*DELTA)
      XMIJKL(2,3,3,1)=XMIJKL(2,3,1,3)
      XMIJKL(3,2,1,3)=XMIJKL(2,3,1,3)
      XMIJKL(3,2,3,1)=XMIJKL(2,3,1,3)
      XMIJKL(3,1,2,3)=XMIJKL(2,3,1,3)
      XMIJKL(3,1,3,2)=XMIJKL(2,3,1,3)
      XMIJKL(1,3,2,3)=XMIJKL(2,3,1,3)
      XMIJKL(1,3,3,2)=XMIJKL(2,3,1,3)
      XMIJKL(2,3,1,2)=(PHI(4)*PHI(5)+PHI(6)*CST2)/(4.D0*DELTA)
      XMIJKL(2,3,2,1)=XMIJKL(2,3,1,2)
      XMIJKL(3,2,1,2)=XMIJKL(2,3,1,2)
      XMIJKL(3,2,2,1)=XMIJKL(2,3,1,2)
      XMIJKL(1,2,2,3)=XMIJKL(2,3,1,2)
      XMIJKL(1,2,3,2)=XMIJKL(2,3,1,2)
      XMIJKL(2,1,2,3)=XMIJKL(2,3,1,2)
      XMIJKL(2,1,3,2)=XMIJKL(2,3,1,2)
      XMIJKL(3,1,1,3)=(CST2*CST3+CST1*CST2-PHI(5)*PHI(5)-PHI(4)*PH
     *I(4))/(4.D0*DELTA)
      XMIJKL(3,1,3,1)=XMIJKL(3,1,1,3)
      XMIJKL(1,3,1,3)=XMIJKL(3,1,1,3)
      XMIJKL(1,3,3,1)=XMIJKL(3,1,1,3)
      XMIJKL(3,1,1,2)=(PHI(4)*PHI(6)+PHI(5)*CST1)/(4.D0*DELTA)
      XMIJKL(3,1,2,1)=XMIJKL(3,1,1,2)
      XMIJKL(1,3,1,2)=XMIJKL(3,1,1,2)
      XMIJKL(1,3,2,1)=XMIJKL(3,1,1,2)
      XMIJKL(1,2,1,3)=XMIJKL(3,1,1,2)
      XMIJKL(1,2,3,1)=XMIJKL(3,1,1,2)
      XMIJKL(2,1,1,3)=XMIJKL(3,1,1,2)
      XMIJKL(2,1,3,1)=XMIJKL(3,1,1,2)
      XMIJKL(1,2,1,2)=(CST2*CST3+CST1*CST3-PHI(5)*PHI(5)-PHI(6)*PH
     *I(6))/(4.D0*DELTA)
      XMIJKL(1,2,2,1)=XMIJKL(1,2,1,2)
      XMIJKL(2,1,1,2)=XMIJKL(1,2,1,2)
      XMIJKL(2,1,2,1)=XMIJKL(1,2,1,2)
C
      RETURN
      END
C =====================================================================
C ======================= A M I N V ===================================
C =====================================================================
      SUBROUTINE AMINV
C THIS SUBPROGRAM CALCULATES THE INVERSE OF M(I,J,K,L)
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON/AMIJK1/XMIJKL(3,3,3,3)
      COMMON/AMINV1/XMTINV(3,3,3,3)
      DIMENSION XM(6,6)
C
      CALL CONVTM(XMIJKL,XM)
      CALL AIINV(XM)
      CALL CONVMT(XM,XMTINV)
C
      RETURN
      END
C =====================================================================
C =====================================================================
C ====================== M D P H I ====================================
C =====================================================================
      SUBROUTINE MDPHI(PHI)
C
C THIS SUBPROGRAM CALCULATES THE SIXTH ORDER TENSOR
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON/MDPHI1/XMPHI(3,3,3,3,3,3)
      DIMENSION PHI(6)
      P1=1.D0-PHI(1)
      P2=1.D0-PHI(2)
      P3=1.D0-PHI(3)
      P4=PHI(5)*PHI(5)*P1
      P5=PHI(6)*PHI(6)*P2
      P6=PHI(4)*PHI(4)*P3
      P7=2.D0*PHI(4)*PHI(5)*PHI(6)
      DT=P1*P2*P3-P4-P5-P6-P7
      D1=-P2*P3+PHI(5)**2
      D2=-P1*P3+PHI(6)**2
      D3=-P1*P2+PHI(4)**2
      D4=-2.D0*(PHI(5)*P1+PHI(4)*PHI(6))
      D5=-2.D0*(PHI(6)*P2+PHI(4)*PHI(5))
      D6=-2.D0*(PHI(4)*P3+PHI(5)*PHI(6))
      X1=P2*P3-PHI(5)**2
      X2=P1*P3-PHI(6)**2
      X3=P1*P2-PHI(4)**2
      X4=PHI(4)*PHI(5)+PHI(6)*P2
      X5=PHI(6)*PHI(5)+PHI(4)*P3
      X6=PHI(4)*PHI(6)+PHI(5)*P1
      X7=P1*P3+P1*P2-PHI(6)**2-PHI(4)**2
      X8=P2*P3+P1*P2-PHI(5)**2-PHI(4)**2
      X9=P2*P3+P1*P3-PHI(5)**2-PHI(6)**2
C
      XMPHI(1,1,1,1,1,1)=-X1*D1/(DT*DT)
      XMPHI(1,1,1,1,2,2)=(-P3*DT-X1*D2)/(DT*DT)
      XMPHI(1,1,1,1,3,3)=(-P2*DT-X1*D3)/(DT*DT)
      XMPHI(1,1,1,1,2,3)=(-2.D0*PHI(5)*DT-X1*D4)/(DT*DT)
      XMPHI(1,1,1,1,3,2)=XMPHI(1,1,1,1,2,3)
      XMPHI(1,1,1,1,3,1)=(-X1*D5)/(DT*DT)
      XMPHI(1,1,1,1,1,3)=XMPHI(1,1,1,1,3,1)
      XMPHI(1,1,1,1,1,2)=(-X1*D6)/(DT*DT)
      XMPHI(1,1,1,1,2,1)=XMPHI(1,1,1,1,1,2)
C
C
      XMPHI(2,2,2,2,1,1)=(-P3*DT-X2*D1)/(DT*DT)
      XMPHI(2,2,2,2,2,2)=(-X2*D2)/(DT*DT)
      XMPHI(2,2,2,2,3,3)=(-P1*DT-X2*D3)/(DT*DT)
      XMPHI(2,2,2,2,2,3)=(-X2*D4)/(DT*DT)
      XMPHI(2,2,2,2,3,2)=XMPHI(2,2,2,2,2,3)
      XMPHI(2,2,2,2,3,1)=(-2.D0*PHI(6)*DT-X2*D5)/(DT*DT)
      XMPHI(2,2,2,2,1,3)=XMPHI(2,2,2,2,3,1)
      XMPHI(2,2,2,2,1,2)=(-X2*D6)/(DT*DT)
      XMPHI(2,2,2,2,2,1)=XMPHI(2,2,2,2,1,2)
C
C
      XMPHI(3,3,3,3,1,1)=(-P2*DT-X3*D1)/(DT*DT)
      XMPHI(3,3,3,3,2,2)=(-P1*DT-X3*D2)/(DT*DT)
      XMPHI(3,3,3,3,3,3)=(-X3*D3)/(DT*DT)
      XMPHI(3,3,3,3,2,3)=(-X3*D4)/(DT*DT)
      XMPHI(3,3,3,3,3,2)=XMPHI(3,3,3,3,2,3)
      XMPHI(3,3,3,3,3,1)=(-2.D0*PHI(4)*DT-X3*D5)/(DT*DT)
      XMPHI(3,3,3,3,1,3)=XMPHI(3,3,3,3,3,1)
      XMPHI(3,3,3,3,1,2)=(-X3*D6)/(DT*DT)
      XMPHI(3,3,3,3,2,1)=XMPHI(3,3,3,3,1,2)
C
C
      XMPHI(1,1,1,3,1,1)=(-X4*D1)/(2.D0*DT*DT)
      XMPHI(1,1,1,3,2,2)=(-PHI(6)*DT-X4*D2)/(2.D0*DT*DT)
      XMPHI(1,1,1,3,3,3)=(-X4*D3)/(2.D0*DT*DT)
      XMPHI(1,1,1,3,2,3)=(PHI(4)*DT-X4*D4)/(2.D0*DT*DT)
      XMPHI(1,1,1,3,3,2)=XMPHI(1,1,1,3,2,3)
      XMPHI(1,1,1,3,3,1)=(P2*DT-X4*D5)/(2.D0*DT*DT)
      XMPHI(1,1,1,3,1,3)=XMPHI(1,1,1,3,3,1)
      XMPHI(1,1,1,3,1,2)=(PHI(5)*DT-X4*D6)/(2.D0*DT*DT)
      XMPHI(1,1,1,3,2,1)=XMPHI(1,1,1,3,1,2)
C
      XMPHI(1,1,3,1,1,1)=XMPHI(1,1,1,3,1,1)
      XMPHI(1,1,3,1,2,2)=XMPHI(1,1,1,3,2,2)
      XMPHI(1,1,3,1,3,3)=XMPHI(1,1,1,3,3,3)
      XMPHI(1,1,3,1,2,3)=XMPHI(1,1,1,3,2,3)
      XMPHI(1,1,3,1,3,2)=XMPHI(1,1,1,3,2,3)
      XMPHI(1,1,3,1,3,1)=XMPHI(1,1,1,3,3,1)
      XMPHI(1,1,3,1,1,3)=XMPHI(1,1,1,3,3,1)
      XMPHI(1,1,3,1,1,2)=XMPHI(1,1,1,3,1,2)
      XMPHI(1,1,3,1,2,1)=XMPHI(1,1,1,3,1,2)
C
      XMPHI(3,3,1,3,1,1)=XMPHI(1,1,1,3,1,1)
      XMPHI(3,3,1,3,2,2)=XMPHI(1,1,1,3,2,2)
      XMPHI(3,3,1,3,3,3)=XMPHI(1,1,1,3,3,3)
      XMPHI(3,3,1,3,2,3)=XMPHI(1,1,1,3,2,3)
      XMPHI(3,3,1,3,3,2)=XMPHI(1,1,1,3,2,3)
      XMPHI(3,3,1,3,3,1)=XMPHI(1,1,1,3,3,1)
      XMPHI(3,3,1,3,1,3)=XMPHI(1,1,1,3,3,1)
      XMPHI(3,3,1,3,1,2)=XMPHI(1,1,1,3,1,2)
      XMPHI(3,3,1,3,2,1)=XMPHI(1,1,1,3,1,2)
C
      XMPHI(3,3,3,1,1,1)=XMPHI(1,1,1,3,1,1)
      XMPHI(3,3,3,1,2,2)=XMPHI(1,1,1,3,2,2)
      XMPHI(3,3,3,1,3,3)=XMPHI(1,1,1,3,3,3)
      XMPHI(3,3,3,1,2,3)=XMPHI(1,1,1,3,2,3)
      XMPHI(3,3,3,1,3,2)=XMPHI(1,1,1,3,2,3)
      XMPHI(3,3,3,1,3,1)=XMPHI(1,1,1,3,3,1)
      XMPHI(3,3,3,1,1,3)=XMPHI(1,1,1,3,3,1)
      XMPHI(3,3,3,1,1,2)=XMPHI(1,1,1,3,1,2)
      XMPHI(3,3,3,1,2,1)=XMPHI(1,1,1,3,1,2)
C
      XMPHI(3,1,1,1,1,1)=XMPHI(1,1,1,3,1,1)
      XMPHI(3,1,1,1,2,2)=XMPHI(1,1,1,3,2,2)
      XMPHI(3,1,1,1,3,3)=XMPHI(1,1,1,3,3,3)
      XMPHI(3,1,1,1,2,3)=XMPHI(1,1,1,3,2,3)
      XMPHI(3,1,1,1,3,2)=XMPHI(1,1,1,3,2,3)
      XMPHI(3,1,1,1,3,1)=XMPHI(1,1,1,3,3,1)
      XMPHI(3,1,1,1,1,3)=XMPHI(1,1,1,3,3,1)
      XMPHI(3,1,1,1,1,2)=XMPHI(1,1,1,3,1,2)
      XMPHI(3,1,1,1,2,1)=XMPHI(1,1,1,3,1,2)
C
      XMPHI(3,1,3,3,1,1)=XMPHI(1,1,1,3,1,1)
      XMPHI(3,1,3,3,2,2)=XMPHI(1,1,1,3,2,2)
      XMPHI(3,1,3,3,3,3)=XMPHI(1,1,1,3,3,3)
      XMPHI(3,1,3,3,2,3)=XMPHI(1,1,1,3,2,3)
      XMPHI(3,1,3,3,3,2)=XMPHI(1,1,1,3,2,3)
      XMPHI(3,1,3,3,3,1)=XMPHI(1,1,1,3,3,1)
      XMPHI(3,1,3,3,1,3)=XMPHI(1,1,1,3,3,1)
      XMPHI(3,1,3,3,1,2)=XMPHI(1,1,1,3,1,2)
      XMPHI(3,1,3,3,2,1)=XMPHI(1,1,1,3,1,2)
C
      XMPHI(1,3,1,1,1,1)=XMPHI(1,1,1,3,1,1)
      XMPHI(1,3,1,1,2,2)=XMPHI(1,1,1,3,2,2)
      XMPHI(1,3,1,1,3,3)=XMPHI(1,1,1,3,3,3)
      XMPHI(1,3,1,1,2,3)=XMPHI(1,1,1,3,2,3)
      XMPHI(1,3,1,1,3,2)=XMPHI(1,1,1,3,2,3)
      XMPHI(1,3,1,1,3,1)=XMPHI(1,1,1,3,3,1)
      XMPHI(1,3,1,1,1,3)=XMPHI(1,1,1,3,3,1)
      XMPHI(1,3,1,1,1,2)=XMPHI(1,1,1,3,1,2)
      XMPHI(1,3,1,1,2,1)=XMPHI(1,1,1,3,1,2)
C
      XMPHI(1,3,3,3,1,1)=XMPHI(1,1,1,3,1,1)
      XMPHI(1,3,3,3,2,2)=XMPHI(1,1,1,3,2,2)
      XMPHI(1,3,3,3,3,3)=XMPHI(1,1,1,3,3,3)
      XMPHI(1,3,3,3,2,3)=XMPHI(1,1,1,3,2,3)
      XMPHI(1,3,3,3,3,2)=XMPHI(1,1,1,3,2,3)
      XMPHI(1,3,3,3,3,1)=XMPHI(1,1,1,3,3,1)
      XMPHI(1,3,3,3,1,3)=XMPHI(1,1,1,3,3,1)
      XMPHI(1,3,3,3,1,2)=XMPHI(1,1,1,3,1,2)
      XMPHI(1,3,3,3,2,1)=XMPHI(1,1,1,3,1,2)
C
C
      XMPHI(2,3,1,2,1,1)=XMPHI(1,1,1,3,1,1)/2.D0
      XMPHI(2,3,1,2,2,2)=XMPHI(1,1,1,3,2,2)/2.D0
      XMPHI(2,3,1,2,3,3)=XMPHI(1,1,1,3,3,3)/2.D0
      XMPHI(2,3,1,2,2,3)=XMPHI(1,1,1,3,2,3)/2.D0
      XMPHI(2,3,1,2,3,2)=XMPHI(1,1,1,3,2,3)/2.D0
      XMPHI(2,3,1,2,3,1)=XMPHI(1,1,1,3,3,1)/2.D0
      XMPHI(2,3,1,2,1,3)=XMPHI(1,1,1,3,3,1)/2.D0
      XMPHI(2,3,1,2,1,2)=XMPHI(1,1,1,3,1,2)/2.D0
      XMPHI(2,3,1,2,2,1)=XMPHI(1,1,1,3,1,2)/2.D0
C
      XMPHI(2,3,2,1,1,1)=XMPHI(2,3,1,2,1,1)
      XMPHI(2,3,2,1,2,2)=XMPHI(2,3,1,2,2,2)
      XMPHI(2,3,2,1,3,3)=XMPHI(2,3,1,2,3,3)
      XMPHI(2,3,2,1,2,3)=XMPHI(2,3,1,2,2,3)
      XMPHI(2,3,2,1,3,2)=XMPHI(2,3,1,2,2,3)
      XMPHI(2,3,2,1,3,1)=XMPHI(2,3,1,2,3,1)
      XMPHI(2,3,2,1,1,3)=XMPHI(2,3,1,2,3,1)
      XMPHI(2,3,2,1,1,2)=XMPHI(2,3,1,2,1,2)
      XMPHI(2,3,2,1,2,1)=XMPHI(2,3,1,2,1,2)
C
      XMPHI(1,2,2,3,1,1)=XMPHI(2,3,1,2,1,1)
      XMPHI(1,2,2,3,2,2)=XMPHI(2,3,1,2,2,2)
      XMPHI(1,2,2,3,3,3)=XMPHI(2,3,1,2,3,3)
      XMPHI(1,2,2,3,2,3)=XMPHI(2,3,1,2,2,3)
      XMPHI(1,2,2,3,3,2)=XMPHI(2,3,1,2,2,3)
      XMPHI(1,2,2,3,3,1)=XMPHI(2,3,1,2,3,1)
      XMPHI(1,2,2,3,1,3)=XMPHI(2,3,1,2,3,1)
      XMPHI(1,2,2,3,1,2)=XMPHI(2,3,1,2,1,2)
      XMPHI(1,2,2,3,2,1)=XMPHI(2,3,1,2,1,2)
C
      XMPHI(1,2,3,2,1,1)=XMPHI(2,3,1,2,1,1)
      XMPHI(1,2,3,2,2,2)=XMPHI(2,3,1,2,2,2)
      XMPHI(1,2,3,2,3,3)=XMPHI(2,3,1,2,3,3)
      XMPHI(1,2,3,2,2,3)=XMPHI(2,3,1,2,2,3)
      XMPHI(1,2,3,2,3,2)=XMPHI(2,3,1,2,2,3)
      XMPHI(1,2,3,2,3,1)=XMPHI(2,3,1,2,3,1)
      XMPHI(1,2,3,2,1,3)=XMPHI(2,3,1,2,3,1)
      XMPHI(1,2,3,2,1,2)=XMPHI(2,3,1,2,1,2)
      XMPHI(1,2,3,2,2,1)=XMPHI(2,3,1,2,1,2)
C
      XMPHI(3,2,1,2,1,1)=XMPHI(2,3,1,2,1,1)
      XMPHI(3,2,1,2,2,2)=XMPHI(2,3,1,2,2,2)
      XMPHI(3,2,1,2,3,3)=XMPHI(2,3,1,2,3,3)
      XMPHI(3,2,1,2,2,3)=XMPHI(2,3,1,2,2,3)
      XMPHI(3,2,1,2,3,2)=XMPHI(2,3,1,2,2,3)
      XMPHI(3,2,1,2,3,1)=XMPHI(2,3,1,2,3,1)
      XMPHI(3,2,1,2,1,3)=XMPHI(2,3,1,2,3,1)
      XMPHI(3,2,1,2,1,2)=XMPHI(2,3,1,2,1,2)
      XMPHI(3,2,1,2,2,1)=XMPHI(2,3,1,2,1,2)
C
      XMPHI(3,2,2,1,1,1)=XMPHI(2,3,1,2,1,1)
      XMPHI(3,2,2,1,2,2)=XMPHI(2,3,1,2,2,2)
      XMPHI(3,2,2,1,3,3)=XMPHI(2,3,1,2,3,3)
      XMPHI(3,2,2,1,2,3)=XMPHI(2,3,1,2,2,3)
      XMPHI(3,2,2,1,3,2)=XMPHI(2,3,1,2,2,3)
      XMPHI(3,2,2,1,3,1)=XMPHI(2,3,1,2,3,1)
      XMPHI(3,2,2,1,1,3)=XMPHI(2,3,1,2,3,1)
      XMPHI(3,2,2,1,1,2)=XMPHI(2,3,1,2,1,2)
      XMPHI(3,2,2,1,2,1)=XMPHI(2,3,1,2,1,2)
C
      XMPHI(2,1,2,3,1,1)=XMPHI(2,3,1,2,1,1)
      XMPHI(2,1,2,3,2,2)=XMPHI(2,3,1,2,2,2)
      XMPHI(2,1,2,3,3,3)=XMPHI(2,3,1,2,3,3)
      XMPHI(2,1,2,3,2,3)=XMPHI(2,3,1,2,2,3)
      XMPHI(2,1,2,3,3,2)=XMPHI(2,3,1,2,2,3)
      XMPHI(2,1,2,3,3,1)=XMPHI(2,3,1,2,3,1)
      XMPHI(2,1,2,3,1,3)=XMPHI(2,3,1,2,3,1)
      XMPHI(2,1,2,3,1,2)=XMPHI(2,3,1,2,1,2)
      XMPHI(2,1,2,3,2,1)=XMPHI(2,3,1,2,1,2)
C
      XMPHI(2,1,3,2,1,1)=XMPHI(2,3,1,2,1,1)
      XMPHI(2,1,3,2,2,2)=XMPHI(2,3,1,2,2,2)
      XMPHI(2,1,3,2,3,3)=XMPHI(2,3,1,2,3,3)
      XMPHI(2,1,3,2,2,3)=XMPHI(2,3,1,2,2,3)
      XMPHI(2,1,3,2,3,2)=XMPHI(2,3,1,2,2,3)
      XMPHI(2,1,3,2,3,1)=XMPHI(2,3,1,2,3,1)
      XMPHI(2,1,3,2,1,3)=XMPHI(2,3,1,2,3,1)
      XMPHI(2,1,3,2,1,2)=XMPHI(2,3,1,2,1,2)
      XMPHI(2,1,3,2,2,1)=XMPHI(2,3,1,2,1,2)
C
C
      XMPHI(1,1,1,2,1,1)=(-X5*D1)/(2.D0*DT*DT)
      XMPHI(1,1,1,2,2,2)=(-X5*D2)/(2.D0*DT*DT)
      XMPHI(1,1,1,2,3,3)=(-PHI(4)*DT-X5*D3)/(2.D0*DT*DT)
      XMPHI(1,1,1,2,2,3)=(PHI(6)*DT-X5*D4)/(2.D0*DT*DT)
      XMPHI(1,1,1,2,3,2)=XMPHI(1,1,1,2,2,3)
      XMPHI(1,1,1,2,3,1)=(PHI(5)*DT-X5*D5)/(2.D0*DT*DT)
      XMPHI(1,1,1,2,1,3)=XMPHI(1,1,1,2,3,1)
      XMPHI(1,1,1,2,1,2)=(P3*DT-X5*D6)/(2.D0*DT*DT)
      XMPHI(1,1,1,2,2,1)=XMPHI(1,1,1,2,1,2)
C
      XMPHI(1,1,2,1,1,1)=XMPHI(1,1,1,2,1,1)
      XMPHI(1,1,2,1,2,2)=XMPHI(1,1,1,2,2,2)
      XMPHI(1,1,2,1,3,3)=XMPHI(1,1,1,2,3,3)
      XMPHI(1,1,2,1,2,3)=XMPHI(1,1,1,2,2,3)
      XMPHI(1,1,2,1,3,2)=XMPHI(1,1,1,2,2,3)
      XMPHI(1,1,2,1,3,1)=XMPHI(1,1,1,2,3,1)
      XMPHI(1,1,2,1,1,3)=XMPHI(1,1,1,2,3,1)
      XMPHI(1,1,2,1,1,2)=XMPHI(1,1,1,2,1,2)
      XMPHI(1,1,2,1,2,1)=XMPHI(1,1,1,2,1,2)
C
      XMPHI(2,2,1,2,1,1)=XMPHI(1,1,1,2,1,1)
      XMPHI(2,2,1,2,2,2)=XMPHI(1,1,1,2,2,2)
      XMPHI(2,2,1,2,3,3)=XMPHI(1,1,1,2,3,3)
      XMPHI(2,2,1,2,2,3)=XMPHI(1,1,1,2,2,3)
      XMPHI(2,2,1,2,3,2)=XMPHI(1,1,1,2,2,3)
      XMPHI(2,2,1,2,3,1)=XMPHI(1,1,1,2,3,1)
      XMPHI(2,2,1,2,1,3)=XMPHI(1,1,1,2,3,1)
      XMPHI(2,2,1,2,1,2)=XMPHI(1,1,1,2,1,2)
      XMPHI(2,2,1,2,2,1)=XMPHI(1,1,1,2,1,2)
C
      XMPHI(2,2,2,1,1,1)=XMPHI(1,1,1,2,1,1)
      XMPHI(2,2,2,1,2,2)=XMPHI(1,1,1,2,2,2)
      XMPHI(2,2,2,1,3,3)=XMPHI(1,1,1,2,3,3)
      XMPHI(2,2,2,1,2,3)=XMPHI(1,1,1,2,2,3)
      XMPHI(2,2,2,1,3,2)=XMPHI(1,1,1,2,2,3)
      XMPHI(2,2,2,1,3,1)=XMPHI(1,1,1,2,3,1)
      XMPHI(2,2,2,1,1,3)=XMPHI(1,1,1,2,3,1)
      XMPHI(2,2,2,1,1,2)=XMPHI(1,1,1,2,1,2)
      XMPHI(2,2,2,1,2,1)=XMPHI(1,1,1,2,1,2)
C
      XMPHI(1,2,1,1,1,1)=XMPHI(1,1,1,2,1,1)
      XMPHI(1,2,1,1,2,2)=XMPHI(1,1,1,2,2,2)
      XMPHI(1,2,1,1,3,3)=XMPHI(1,1,1,2,3,3)
      XMPHI(1,2,1,1,2,3)=XMPHI(1,1,1,2,2,3)
      XMPHI(1,2,1,1,3,2)=XMPHI(1,1,1,2,2,3)
      XMPHI(1,2,1,1,3,1)=XMPHI(1,1,1,2,3,1)
      XMPHI(1,2,1,1,1,3)=XMPHI(1,1,1,2,3,1)
      XMPHI(1,2,1,1,1,2)=XMPHI(1,1,1,2,1,2)
      XMPHI(1,2,1,1,2,1)=XMPHI(1,1,1,2,1,2)
C
      XMPHI(1,2,2,2,1,1)=XMPHI(1,1,1,2,1,1)
      XMPHI(1,2,2,2,2,2)=XMPHI(1,1,1,2,2,2)
      XMPHI(1,2,2,2,3,3)=XMPHI(1,1,1,2,3,3)
      XMPHI(1,2,2,2,2,3)=XMPHI(1,1,1,2,2,3)
      XMPHI(1,2,2,2,3,2)=XMPHI(1,1,1,2,2,3)
      XMPHI(1,2,2,2,3,1)=XMPHI(1,1,1,2,3,1)
      XMPHI(1,2,2,2,1,3)=XMPHI(1,1,1,2,3,1)
      XMPHI(1,2,2,2,1,2)=XMPHI(1,1,1,2,1,2)
      XMPHI(1,2,2,2,2,1)=XMPHI(1,1,1,2,1,2)
C
      XMPHI(2,1,1,1,1,1)=XMPHI(1,1,1,2,1,1)
      XMPHI(2,1,1,1,2,2)=XMPHI(1,1,1,2,2,2)
      XMPHI(2,1,1,1,3,3)=XMPHI(1,1,1,2,3,3)
      XMPHI(2,1,1,1,2,3)=XMPHI(1,1,1,2,2,3)
      XMPHI(2,1,1,1,3,2)=XMPHI(1,1,1,2,2,3)
      XMPHI(2,1,1,1,3,1)=XMPHI(1,1,1,2,3,1)
      XMPHI(2,1,1,1,1,3)=XMPHI(1,1,1,2,3,1)
      XMPHI(2,1,1,1,1,2)=XMPHI(1,1,1,2,1,2)
      XMPHI(2,1,1,1,2,1)=XMPHI(1,1,1,2,1,2)
C
      XMPHI(2,1,2,2,1,1)=XMPHI(1,1,1,2,1,1)
      XMPHI(2,1,2,2,2,2)=XMPHI(1,1,1,2,2,2)
      XMPHI(2,1,2,2,3,3)=XMPHI(1,1,1,2,3,3)
      XMPHI(2,1,2,2,2,3)=XMPHI(1,1,1,2,2,3)
      XMPHI(2,1,2,2,3,2)=XMPHI(1,1,1,2,2,3)
      XMPHI(2,1,2,2,3,1)=XMPHI(1,1,1,2,3,1)
      XMPHI(2,1,2,2,1,3)=XMPHI(1,1,1,2,3,1)
      XMPHI(2,1,2,2,1,2)=XMPHI(1,1,1,2,1,2)
      XMPHI(2,1,2,2,2,1)=XMPHI(1,1,1,2,1,2)
C
C
      XMPHI(2,3,1,3,1,1)=XMPHI(1,1,1,2,1,1)/2.D0
      XMPHI(2,3,1,3,2,2)=XMPHI(1,1,1,2,2,2)/2.D0
      XMPHI(2,3,1,3,3,3)=XMPHI(1,1,1,2,3,3)/2.D0
      XMPHI(2,3,1,3,2,3)=XMPHI(1,1,1,2,2,3)/2.D0
      XMPHI(2,3,1,3,3,2)=XMPHI(1,1,1,2,2,3)/2.D0
      XMPHI(2,3,1,3,3,1)=XMPHI(1,1,1,2,3,1)/2.D0
      XMPHI(2,3,1,3,1,3)=XMPHI(1,1,1,2,3,1)/2.D0
      XMPHI(2,3,1,3,1,2)=XMPHI(1,1,1,2,1,2)/2.D0
      XMPHI(2,3,1,3,2,1)=XMPHI(1,1,1,2,1,2)/2.D0
C
      XMPHI(2,3,3,1,1,1)=XMPHI(2,3,1,3,1,1)
      XMPHI(2,3,3,1,2,2)=XMPHI(2,3,1,3,2,2)
      XMPHI(2,3,3,1,3,3)=XMPHI(2,3,1,3,3,3)
      XMPHI(2,3,3,1,2,3)=XMPHI(2,3,1,3,2,3)
      XMPHI(2,3,3,1,3,2)=XMPHI(2,3,1,3,2,3)
      XMPHI(2,3,3,1,3,1)=XMPHI(2,3,1,3,3,1)
      XMPHI(2,3,3,1,1,3)=XMPHI(2,3,1,3,3,1)
      XMPHI(2,3,3,1,1,2)=XMPHI(2,3,1,3,1,2)
      XMPHI(2,3,3,1,2,1)=XMPHI(2,3,1,3,1,2)
C
      XMPHI(3,1,2,3,1,1)=XMPHI(2,3,1,3,1,1)
      XMPHI(3,1,2,3,2,2)=XMPHI(2,3,1,3,2,2)
      XMPHI(3,1,2,3,3,3)=XMPHI(2,3,1,3,3,3)
      XMPHI(3,1,2,3,2,3)=XMPHI(2,3,1,3,2,3)
      XMPHI(3,1,2,3,3,2)=XMPHI(2,3,1,3,2,3)
      XMPHI(3,1,2,3,3,1)=XMPHI(2,3,1,3,3,1)
      XMPHI(3,1,2,3,1,3)=XMPHI(2,3,1,3,3,1)
      XMPHI(3,1,2,3,1,2)=XMPHI(2,3,1,3,1,2)
      XMPHI(3,1,2,3,2,1)=XMPHI(2,3,1,3,1,2)
C
      XMPHI(3,1,3,2,1,1)=XMPHI(2,3,1,3,1,1)
      XMPHI(3,1,3,2,2,2)=XMPHI(2,3,1,3,2,2)
      XMPHI(3,1,3,2,3,3)=XMPHI(2,3,1,3,3,3)
      XMPHI(3,1,3,2,2,3)=XMPHI(2,3,1,3,2,3)
      XMPHI(3,1,3,2,3,2)=XMPHI(2,3,1,3,2,3)
      XMPHI(3,1,3,2,3,1)=XMPHI(2,3,1,3,3,1)
      XMPHI(3,1,3,2,1,3)=XMPHI(2,3,1,3,3,1)
      XMPHI(3,1,3,2,1,2)=XMPHI(2,3,1,3,1,2)
      XMPHI(3,1,3,2,2,1)=XMPHI(2,3,1,3,1,2)
C
      XMPHI(3,2,1,3,1,1)=XMPHI(2,3,1,3,1,1)
      XMPHI(3,2,1,3,2,2)=XMPHI(2,3,1,3,2,2)
      XMPHI(3,2,1,3,3,3)=XMPHI(2,3,1,3,3,3)
      XMPHI(3,2,1,3,2,3)=XMPHI(2,3,1,3,2,3)
      XMPHI(3,2,1,3,3,2)=XMPHI(2,3,1,3,2,3)
      XMPHI(3,2,1,3,3,1)=XMPHI(2,3,1,3,3,1)
      XMPHI(3,2,1,3,1,3)=XMPHI(2,3,1,3,3,1)
      XMPHI(3,2,1,3,1,2)=XMPHI(2,3,1,3,1,2)
      XMPHI(3,2,1,3,2,1)=XMPHI(2,3,1,3,1,2)
C
      XMPHI(3,2,3,1,1,1)=XMPHI(2,3,1,3,1,1)
      XMPHI(3,2,3,1,2,2)=XMPHI(2,3,1,3,2,2)
      XMPHI(3,2,3,1,3,3)=XMPHI(2,3,1,3,3,3)
      XMPHI(3,2,3,1,2,3)=XMPHI(2,3,1,3,2,3)
      XMPHI(3,2,3,1,3,2)=XMPHI(2,3,1,3,2,3)
      XMPHI(3,2,3,1,3,1)=XMPHI(2,3,1,3,3,1)
      XMPHI(3,2,3,1,1,3)=XMPHI(2,3,1,3,3,1)
      XMPHI(3,2,3,1,1,2)=XMPHI(2,3,1,3,1,2)
      XMPHI(3,2,3,1,2,1)=XMPHI(2,3,1,3,1,2)
C
      XMPHI(1,3,2,3,1,1)=XMPHI(2,3,1,3,1,1)
      XMPHI(1,3,2,3,2,2)=XMPHI(2,3,1,3,2,2)
      XMPHI(1,3,2,3,3,3)=XMPHI(2,3,1,3,3,3)
      XMPHI(1,3,2,3,2,3)=XMPHI(2,3,1,3,2,3)
      XMPHI(1,3,2,3,3,2)=XMPHI(2,3,1,3,2,3)
      XMPHI(1,3,2,3,3,1)=XMPHI(2,3,1,3,3,1)
      XMPHI(1,3,2,3,1,3)=XMPHI(2,3,1,3,3,1)
      XMPHI(1,3,2,3,1,2)=XMPHI(2,3,1,3,1,2)
      XMPHI(1,3,2,3,2,1)=XMPHI(2,3,1,3,1,2)
C
      XMPHI(1,3,3,2,1,1)=XMPHI(2,3,1,3,1,1)
      XMPHI(1,3,3,2,2,2)=XMPHI(2,3,1,3,2,2)
      XMPHI(1,3,3,2,3,3)=XMPHI(2,3,1,3,3,3)
      XMPHI(1,3,3,2,2,3)=XMPHI(2,3,1,3,2,3)
      XMPHI(1,3,3,2,3,2)=XMPHI(2,3,1,3,2,3)
      XMPHI(1,3,3,2,3,1)=XMPHI(2,3,1,3,3,1)
      XMPHI(1,3,3,2,1,3)=XMPHI(2,3,1,3,3,1)
      XMPHI(1,3,3,2,1,2)=XMPHI(2,3,1,3,1,2)
      XMPHI(1,3,3,2,2,1)=XMPHI(2,3,1,3,1,2)
C
C
      XMPHI(2,2,2,3,1,1)=(-PHI(5)*DT-X6*D1)/(2.D0*DT*DT)
      XMPHI(2,2,2,3,2,2)=(-X6*D2)/(2.D0*DT*DT)
      XMPHI(2,2,2,3,3,3)=(-X6*D3)/(2.D0*DT*DT)
      XMPHI(2,2,2,3,2,3)=(P1*DT-X6*D4)/(2.D0*DT*DT)
      XMPHI(2,2,2,3,3,2)=XMPHI(2,2,2,3,2,3)
      XMPHI(2,2,2,3,1,3)=(PHI(4)*DT-X6*D5)/(2.D0*DT*DT)
      XMPHI(2,2,2,3,3,1)=XMPHI(2,2,2,3,1,3)
      XMPHI(2,2,2,3,1,2)=(PHI(6)*DT-X6*D6)/(2.D0*DT*DT)
      XMPHI(2,2,2,3,2,1)=XMPHI(2,2,2,3,1,2)
C
      XMPHI(2,2,3,2,1,1)=XMPHI(2,2,2,3,1,1)
      XMPHI(2,2,3,2,2,2)=XMPHI(2,2,2,3,2,2)
      XMPHI(2,2,3,2,3,3)=XMPHI(2,2,2,3,3,3)
      XMPHI(2,2,3,2,2,3)=XMPHI(2,2,2,3,2,3)
      XMPHI(2,2,3,2,3,2)=XMPHI(2,2,2,3,2,3)
      XMPHI(2,2,3,2,1,3)=XMPHI(2,2,2,3,1,3)
      XMPHI(2,2,3,2,3,1)=XMPHI(2,2,2,3,1,3)
      XMPHI(2,2,3,2,1,2)=XMPHI(2,2,2,3,1,2)
      XMPHI(2,2,3,2,2,1)=XMPHI(2,2,2,3,1,2)
C
      XMPHI(3,3,2,3,1,1)=XMPHI(2,2,2,3,1,1)
      XMPHI(3,3,2,3,2,2)=XMPHI(2,2,2,3,2,2)
      XMPHI(3,3,2,3,3,3)=XMPHI(2,2,2,3,3,3)
      XMPHI(3,3,2,3,2,3)=XMPHI(2,2,2,3,2,3)
      XMPHI(3,3,2,3,3,2)=XMPHI(2,2,2,3,2,3)
      XMPHI(3,3,2,3,1,3)=XMPHI(2,2,2,3,1,3)
      XMPHI(3,3,2,3,3,1)=XMPHI(2,2,2,3,1,3)
      XMPHI(3,3,2,3,1,2)=XMPHI(2,2,2,3,1,2)
      XMPHI(3,3,2,3,2,1)=XMPHI(2,2,2,3,1,2)
C
      XMPHI(3,3,3,2,1,1)=XMPHI(2,2,2,3,1,1)
      XMPHI(3,3,3,2,2,2)=XMPHI(2,2,2,3,2,2)
      XMPHI(3,3,3,2,3,3)=XMPHI(2,2,2,3,3,3)
      XMPHI(3,3,3,2,2,3)=XMPHI(2,2,2,3,2,3)
      XMPHI(3,3,3,2,3,2)=XMPHI(2,2,2,3,2,3)
      XMPHI(3,3,3,2,1,3)=XMPHI(2,2,2,3,1,3)
      XMPHI(3,3,3,2,3,1)=XMPHI(2,2,2,3,1,3)
      XMPHI(3,3,3,2,1,2)=XMPHI(2,2,2,3,1,2)
      XMPHI(3,3,3,2,2,1)=XMPHI(2,2,2,3,1,2)
C
      XMPHI(2,3,2,2,1,1)=XMPHI(2,2,2,3,1,1)
      XMPHI(2,3,2,2,2,2)=XMPHI(2,2,2,3,2,2)
      XMPHI(2,3,2,2,3,3)=XMPHI(2,2,2,3,3,3)
      XMPHI(2,3,2,2,2,3)=XMPHI(2,2,2,3,2,3)
      XMPHI(2,3,2,2,3,2)=XMPHI(2,2,2,3,2,3)
      XMPHI(2,3,2,2,1,3)=XMPHI(2,2,2,3,1,3)
      XMPHI(2,3,2,2,3,1)=XMPHI(2,2,2,3,1,3)
      XMPHI(2,3,2,2,1,2)=XMPHI(2,2,2,3,1,2)
      XMPHI(2,3,2,2,2,1)=XMPHI(2,2,2,3,1,2)
C
      XMPHI(2,3,3,3,1,1)=XMPHI(2,2,2,3,1,1)
      XMPHI(2,3,3,3,2,2)=XMPHI(2,2,2,3,2,2)
      XMPHI(2,3,3,3,3,3)=XMPHI(2,2,2,3,3,3)
      XMPHI(2,3,3,3,2,3)=XMPHI(2,2,2,3,2,3)
      XMPHI(2,3,3,3,3,2)=XMPHI(2,2,2,3,2,3)
      XMPHI(2,3,3,3,1,3)=XMPHI(2,2,2,3,1,3)
      XMPHI(2,3,3,3,3,1)=XMPHI(2,2,2,3,1,3)
      XMPHI(2,3,3,3,1,2)=XMPHI(2,2,2,3,1,2)
      XMPHI(2,3,3,3,2,1)=XMPHI(2,2,2,3,1,2)
C
      XMPHI(3,2,2,2,1,1)=XMPHI(2,2,2,3,1,1)
      XMPHI(3,2,2,2,2,2)=XMPHI(2,2,2,3,2,2)
      XMPHI(3,2,2,2,3,3)=XMPHI(2,2,2,3,3,3)
      XMPHI(3,2,2,2,2,3)=XMPHI(2,2,2,3,2,3)
      XMPHI(3,2,2,2,3,2)=XMPHI(2,2,2,3,2,3)
      XMPHI(3,2,2,2,1,3)=XMPHI(2,2,2,3,1,3)
      XMPHI(3,2,2,2,3,1)=XMPHI(2,2,2,3,1,3)
      XMPHI(3,2,2,2,1,2)=XMPHI(2,2,2,3,1,2)
      XMPHI(3,2,2,2,2,1)=XMPHI(2,2,2,3,1,2)
C
      XMPHI(3,2,3,3,1,1)=XMPHI(2,2,2,3,1,1)
      XMPHI(3,2,3,3,2,2)=XMPHI(2,2,2,3,2,2)
      XMPHI(3,2,3,3,3,3)=XMPHI(2,2,2,3,3,3)
      XMPHI(3,2,3,3,2,3)=XMPHI(2,2,2,3,2,3)
      XMPHI(3,2,3,3,3,2)=XMPHI(2,2,2,3,2,3)
      XMPHI(3,2,3,3,1,3)=XMPHI(2,2,2,3,1,3)
      XMPHI(3,2,3,3,3,1)=XMPHI(2,2,2,3,1,3)
      XMPHI(3,2,3,3,1,2)=XMPHI(2,2,2,3,1,2)
      XMPHI(3,2,3,3,2,1)=XMPHI(2,2,2,3,1,2)
C
C
      XMPHI(3,1,1,2,1,1)=XMPHI(2,2,2,3,1,1)/2.D0
      XMPHI(3,1,1,2,2,2)=XMPHI(2,2,2,3,2,2)/2.D0
      XMPHI(3,1,1,2,3,3)=XMPHI(2,2,2,3,3,3)/2.D0
      XMPHI(3,1,1,2,2,3)=XMPHI(2,2,2,3,2,3)/2.D0
      XMPHI(3,1,1,2,3,2)=XMPHI(2,2,2,3,2,3)/2.D0
      XMPHI(3,1,1,2,1,3)=XMPHI(2,2,2,3,1,3)/2.D0
      XMPHI(3,1,1,2,3,1)=XMPHI(2,2,2,3,1,3)/2.D0
      XMPHI(3,1,1,2,1,2)=XMPHI(2,2,2,3,1,2)/2.D0
      XMPHI(3,1,1,2,2,1)=XMPHI(2,2,2,3,1,2)/2.D0
C
      XMPHI(3,1,2,1,1,1)=XMPHI(3,1,1,2,1,1)
      XMPHI(3,1,2,1,2,2)=XMPHI(3,1,1,2,2,2)
      XMPHI(3,1,2,1,3,3)=XMPHI(3,1,1,2,3,3)
      XMPHI(3,1,2,1,2,3)=XMPHI(3,1,1,2,2,3)
      XMPHI(3,1,2,1,3,2)=XMPHI(3,1,1,2,2,3)
      XMPHI(3,1,2,1,1,3)=XMPHI(3,1,1,2,1,3)
      XMPHI(3,1,2,1,3,1)=XMPHI(3,1,1,2,1,3)
      XMPHI(3,1,2,1,1,2)=XMPHI(3,1,1,2,1,2)
      XMPHI(3,1,2,1,2,1)=XMPHI(3,1,1,2,1,2)
C
      XMPHI(1,2,1,3,1,1)=XMPHI(3,1,1,2,1,1)
      XMPHI(1,2,1,3,2,2)=XMPHI(3,1,1,2,2,2)
      XMPHI(1,2,1,3,3,3)=XMPHI(3,1,1,2,3,3)
      XMPHI(1,2,1,3,2,3)=XMPHI(3,1,1,2,2,3)
      XMPHI(1,2,1,3,3,2)=XMPHI(3,1,1,2,2,3)
      XMPHI(1,2,1,3,1,3)=XMPHI(3,1,1,2,1,3)
      XMPHI(1,2,1,3,3,1)=XMPHI(3,1,1,2,1,3)
      XMPHI(1,2,1,3,1,2)=XMPHI(3,1,1,2,1,2)
      XMPHI(1,2,1,3,2,1)=XMPHI(3,1,1,2,1,2)
C
      XMPHI(1,2,3,1,1,1)=XMPHI(3,1,1,2,1,1)
      XMPHI(1,2,3,1,2,2)=XMPHI(3,1,1,2,2,2)
      XMPHI(1,2,3,1,3,3)=XMPHI(3,1,1,2,3,3)
      XMPHI(1,2,3,1,2,3)=XMPHI(3,1,1,2,2,3)
      XMPHI(1,2,3,1,3,2)=XMPHI(3,1,1,2,2,3)
      XMPHI(1,2,3,1,1,3)=XMPHI(3,1,1,2,1,3)
      XMPHI(1,2,3,1,3,1)=XMPHI(3,1,1,2,1,3)
      XMPHI(1,2,3,1,1,2)=XMPHI(3,1,1,2,1,2)
      XMPHI(1,2,3,1,2,1)=XMPHI(3,1,1,2,1,2)
C
      XMPHI(1,3,1,2,1,1)=XMPHI(3,1,1,2,1,1)
      XMPHI(1,3,1,2,2,2)=XMPHI(3,1,1,2,2,2)
      XMPHI(1,3,1,2,3,3)=XMPHI(3,1,1,2,3,3)
      XMPHI(1,3,1,2,2,3)=XMPHI(3,1,1,2,2,3)
      XMPHI(1,3,1,2,3,2)=XMPHI(3,1,1,2,2,3)
      XMPHI(1,3,1,2,1,3)=XMPHI(3,1,1,2,1,3)
      XMPHI(1,3,1,2,3,1)=XMPHI(3,1,1,2,1,3)
      XMPHI(1,3,1,2,1,2)=XMPHI(3,1,1,2,1,2)
      XMPHI(1,3,1,2,2,1)=XMPHI(3,1,1,2,1,2)
C
      XMPHI(1,3,2,1,1,1)=XMPHI(3,1,1,2,1,1)
      XMPHI(1,3,2,1,2,2)=XMPHI(3,1,1,2,2,2)
      XMPHI(1,3,2,1,3,3)=XMPHI(3,1,1,2,3,3)
      XMPHI(1,3,2,1,2,3)=XMPHI(3,1,1,2,2,3)
      XMPHI(1,3,2,1,3,2)=XMPHI(3,1,1,2,2,3)
      XMPHI(1,3,2,1,1,3)=XMPHI(3,1,1,2,1,3)
      XMPHI(1,3,2,1,3,1)=XMPHI(3,1,1,2,1,3)
      XMPHI(1,3,2,1,1,2)=XMPHI(3,1,1,2,1,2)
      XMPHI(1,3,2,1,2,1)=XMPHI(3,1,1,2,1,2)
C
      XMPHI(2,1,1,3,1,1)=XMPHI(3,1,1,2,1,1)
      XMPHI(2,1,1,3,2,2)=XMPHI(3,1,1,2,2,2)
      XMPHI(2,1,1,3,3,3)=XMPHI(3,1,1,2,3,3)
      XMPHI(2,1,1,3,2,3)=XMPHI(3,1,1,2,2,3)
      XMPHI(2,1,1,3,3,2)=XMPHI(3,1,1,2,2,3)
      XMPHI(2,1,1,3,1,3)=XMPHI(3,1,1,2,1,3)
      XMPHI(2,1,1,3,3,1)=XMPHI(3,1,1,2,1,3)
      XMPHI(2,1,1,3,1,2)=XMPHI(3,1,1,2,1,2)
      XMPHI(2,1,1,3,2,1)=XMPHI(3,1,1,2,1,2)
C
      XMPHI(2,1,3,1,1,1)=XMPHI(3,1,1,2,1,1)
      XMPHI(2,1,3,1,2,2)=XMPHI(3,1,1,2,2,2)
      XMPHI(2,1,3,1,3,3)=XMPHI(3,1,1,2,3,3)
      XMPHI(2,1,3,1,2,3)=XMPHI(3,1,1,2,2,3)
      XMPHI(2,1,3,1,3,2)=XMPHI(3,1,1,2,2,3)
      XMPHI(2,1,3,1,1,3)=XMPHI(3,1,1,2,1,3)
      XMPHI(2,1,3,1,3,1)=XMPHI(3,1,1,2,1,3)
      XMPHI(2,1,3,1,1,2)=XMPHI(3,1,1,2,1,2)
      XMPHI(2,1,3,1,2,1)=XMPHI(3,1,1,2,1,2)
C
C
      XMPHI(2,3,2,3,1,1)=((-P3-P2)*DT-X7*D1)/(4.D0*DT*DT)
      XMPHI(2,3,2,3,2,2)=(-P1*DT-X7*D2)/(4.D0*DT*DT)
      XMPHI(2,3,2,3,3,3)=(-P1*DT-X7*D3)/(4.D0*DT*DT)
      XMPHI(2,3,2,3,2,3)=(-X7*D4)/(4.D0*DT*DT)
      XMPHI(2,3,2,3,3,2)=XMPHI(2,3,2,3,2,3)
      XMPHI(2,3,2,3,1,3)=(-2.D0*PHI(6)*DT-X7*D5)/(4.D0*DT*DT)
      XMPHI(2,3,2,3,3,1)=XMPHI(2,3,2,3,1,3)
      XMPHI(2,3,2,3,1,2)=(-2.D0*PHI(4)*DT-X7*D6)/(4.D0*DT*DT)
      XMPHI(2,3,2,3,2,1)=XMPHI(2,3,2,3,1,2)
C
      XMPHI(2,3,3,2,1,1)=XMPHI(2,3,2,3,1,1)
      XMPHI(2,3,3,2,2,2)=XMPHI(2,3,2,3,2,2)
      XMPHI(2,3,3,2,3,3)=XMPHI(2,3,2,3,3,3)
      XMPHI(2,3,3,2,2,3)=XMPHI(2,3,2,3,2,3)
      XMPHI(2,3,3,2,3,2)=XMPHI(2,3,2,3,2,3)
      XMPHI(2,3,3,2,1,3)=XMPHI(2,3,2,3,1,3)
      XMPHI(2,3,3,2,3,1)=XMPHI(2,3,2,3,1,3)
      XMPHI(2,3,3,2,1,2)=XMPHI(2,3,2,3,1,2)
      XMPHI(2,3,3,2,2,1)=XMPHI(2,3,2,3,1,2)
C
      XMPHI(3,2,2,3,1,1)=XMPHI(2,3,2,3,1,1)
      XMPHI(3,2,2,3,2,2)=XMPHI(2,3,2,3,2,2)
      XMPHI(3,2,2,3,3,3)=XMPHI(2,3,2,3,3,3)
      XMPHI(3,2,2,3,2,3)=XMPHI(2,3,2,3,2,3)
      XMPHI(3,2,2,3,3,2)=XMPHI(2,3,2,3,2,3)
      XMPHI(3,2,2,3,1,3)=XMPHI(2,3,2,3,1,3)
      XMPHI(3,2,2,3,3,1)=XMPHI(2,3,2,3,1,3)
      XMPHI(3,2,2,3,1,2)=XMPHI(2,3,2,3,1,2)
      XMPHI(3,2,2,3,2,1)=XMPHI(2,3,2,3,1,2)
C
      XMPHI(3,2,3,2,1,1)=XMPHI(2,3,2,3,1,1)
      XMPHI(3,2,3,2,2,2)=XMPHI(2,3,2,3,2,2)
      XMPHI(3,2,3,2,3,3)=XMPHI(2,3,2,3,3,3)
      XMPHI(3,2,3,2,2,3)=XMPHI(2,3,2,3,2,3)
      XMPHI(3,2,3,2,3,2)=XMPHI(2,3,2,3,2,3)
      XMPHI(3,2,3,2,1,3)=XMPHI(2,3,2,3,1,3)
      XMPHI(3,2,3,2,3,1)=XMPHI(2,3,2,3,1,3)
      XMPHI(3,2,3,2,1,2)=XMPHI(2,3,2,3,1,2)
      XMPHI(3,2,3,2,2,1)=XMPHI(2,3,2,3,1,2)
C
C
      XMPHI(3,1,1,3,1,1)=(-P2*DT-X8*D1)/(4.D0*DT*DT)
      XMPHI(3,1,1,3,2,2)=((-P3-P1)*DT-X8*D2)/(4.D0*DT*DT)
      XMPHI(3,1,1,3,3,3)=(-P2*DT-X8*D3)/(4.D0*DT*DT)
      XMPHI(3,1,1,3,2,3)=(-2.D0*PHI(5)*DT-X8*D4)/(4.D0*DT*DT)
      XMPHI(3,1,1,3,3,2)=XMPHI(3,1,1,3,2,3)
      XMPHI(3,1,1,3,1,3)=(-X8*D5)/(4.D0*DT*DT)
      XMPHI(3,1,1,3,3,1)=XMPHI(3,1,1,3,1,3)
      XMPHI(3,1,1,3,1,2)=(-2.D0*PHI(4)*DT-X8*D6)/(4.D0*DT*DT)
      XMPHI(3,1,1,3,2,1)=XMPHI(3,1,1,3,1,2)
C
      XMPHI(3,1,3,1,1,1)=XMPHI(3,1,1,3,1,1)
      XMPHI(3,1,3,1,2,2)=XMPHI(3,1,1,3,2,2)
      XMPHI(3,1,3,1,3,3)=XMPHI(3,1,1,3,3,3)
      XMPHI(3,1,3,1,2,3)=XMPHI(3,1,1,3,2,3)
      XMPHI(3,1,3,1,3,2)=XMPHI(3,1,1,3,2,3)
      XMPHI(3,1,3,1,1,3)=XMPHI(3,1,1,3,1,3)
      XMPHI(3,1,3,1,3,1)=XMPHI(3,1,1,3,1,3)
      XMPHI(3,1,3,1,1,2)=XMPHI(3,1,1,3,1,2)
      XMPHI(3,1,3,1,2,1)=XMPHI(3,1,1,3,1,2)
C
      XMPHI(1,3,1,3,1,1)=XMPHI(3,1,1,3,1,1)
      XMPHI(1,3,1,3,2,2)=XMPHI(3,1,1,3,2,2)
      XMPHI(1,3,1,3,3,3)=XMPHI(3,1,1,3,3,3)
      XMPHI(1,3,1,3,2,3)=XMPHI(3,1,1,3,2,3)
      XMPHI(1,3,1,3,3,2)=XMPHI(3,1,1,3,2,3)
      XMPHI(1,3,1,3,1,3)=XMPHI(3,1,1,3,1,3)
      XMPHI(1,3,1,3,3,1)=XMPHI(3,1,1,3,1,3)
      XMPHI(1,3,1,3,1,2)=XMPHI(3,1,1,3,1,2)
      XMPHI(1,3,1,3,2,1)=XMPHI(3,1,1,3,1,2)
C
      XMPHI(1,3,3,1,1,1)=XMPHI(3,1,1,3,1,1)
      XMPHI(1,3,3,1,2,2)=XMPHI(3,1,1,3,2,2)
      XMPHI(1,3,3,1,3,3)=XMPHI(3,1,1,3,3,3)
      XMPHI(1,3,3,1,2,3)=XMPHI(3,1,1,3,2,3)
      XMPHI(1,3,3,1,3,2)=XMPHI(3,1,1,3,2,3)
      XMPHI(1,3,3,1,1,3)=XMPHI(3,1,1,3,1,3)
      XMPHI(1,3,3,1,3,1)=XMPHI(3,1,1,3,1,3)
      XMPHI(1,3,3,1,1,2)=XMPHI(3,1,1,3,1,2)
      XMPHI(1,3,3,1,2,1)=XMPHI(3,1,1,3,1,2)
C
C
      XMPHI(1,2,1,2,1,1)=(-P3*DT-X9*D1)/(4.D0*DT*DT)
      XMPHI(1,2,1,2,2,2)=(-P3*DT-X9*D2)/(4.D0*DT*DT)
      XMPHI(1,2,1,2,3,3)=((-P2-P1)*DT-X9*D3)/(4.D0*DT*DT)
      XMPHI(1,2,1,2,2,3)=(-2.D0*PHI(5)*DT-X9*D4)/(4.D0*DT*DT)
      XMPHI(1,2,1,2,3,2)=XMPHI(1,2,1,2,2,3)
      XMPHI(1,2,1,2,1,3)=(-2.D0*PHI(6)*DT-X9*D5)/(4.D0*DT*DT)
      XMPHI(1,2,1,2,3,1)=XMPHI(1,2,1,2,1,3)
      XMPHI(1,2,1,2,1,2)=(-X9*D6)/(4.D0*DT*DT)
      XMPHI(1,2,1,2,2,1)=XMPHI(1,2,1,2,1,2)
C
      XMPHI(1,2,2,1,1,1)=XMPHI(1,2,1,2,1,1)
      XMPHI(1,2,2,1,2,2)=XMPHI(1,2,1,2,2,2)
      XMPHI(1,2,2,1,3,3)=XMPHI(1,2,1,2,3,3)
      XMPHI(1,2,2,1,2,3)=XMPHI(1,2,1,2,2,3)
      XMPHI(1,2,2,1,3,2)=XMPHI(1,2,1,2,2,3)
      XMPHI(1,2,2,1,1,3)=XMPHI(1,2,1,2,1,3)
      XMPHI(1,2,2,1,3,1)=XMPHI(1,2,1,2,1,3)
      XMPHI(1,2,2,1,1,2)=XMPHI(1,2,1,2,1,2)
      XMPHI(1,2,2,1,2,1)=XMPHI(1,2,1,2,1,2)
C
      XMPHI(2,1,1,2,1,1)=XMPHI(1,2,1,2,1,1)
      XMPHI(2,1,1,2,2,2)=XMPHI(1,2,1,2,2,2)
      XMPHI(2,1,1,2,3,3)=XMPHI(1,2,1,2,3,3)
      XMPHI(2,1,1,2,2,3)=XMPHI(1,2,1,2,2,3)
      XMPHI(2,1,1,2,3,2)=XMPHI(1,2,1,2,2,3)
      XMPHI(2,1,1,2,1,3)=XMPHI(1,2,1,2,1,3)
      XMPHI(2,1,1,2,3,1)=XMPHI(1,2,1,2,1,3)
      XMPHI(2,1,1,2,1,2)=XMPHI(1,2,1,2,1,2)
      XMPHI(2,1,1,2,2,1)=XMPHI(1,2,1,2,1,2)
C
      XMPHI(2,1,2,1,1,1)=XMPHI(1,2,1,2,1,1)
      XMPHI(2,1,2,1,2,2)=XMPHI(1,2,1,2,2,2)
      XMPHI(2,1,2,1,3,3)=XMPHI(1,2,1,2,3,3)
      XMPHI(2,1,2,1,2,3)=XMPHI(1,2,1,2,2,3)
      XMPHI(2,1,2,1,3,2)=XMPHI(1,2,1,2,2,3)
      XMPHI(2,1,2,1,1,3)=XMPHI(1,2,1,2,1,3)
      XMPHI(2,1,2,1,3,1)=XMPHI(1,2,1,2,1,3)
      XMPHI(2,1,2,1,1,2)=XMPHI(1,2,1,2,1,2)
      XMPHI(2,1,2,1,2,1)=XMPHI(1,2,1,2,1,2)
C
      RETURN
      END
C ===================================================================
C ======================= SYMMET ====================================
C ===================================================================
      SUBROUTINE SYMMET(S)
      REAL*8 S
      DIMENSION S(3,3,3,3)
C
      S(1,1,1,1)=S(1,1,1,1)
      S(2,2,2,2)=S(2,2,2,2)
      S(3,3,3,3)=S(3,3,3,3)
C
      S(1,1,2,2)=(S(1,1,2,2)+S(2,2,1,1))*0.5D0
      S(2,2,1,1)=S(1,1,2,2)
C
      S(1,1,3,3)=(S(1,1,3,3)+S(3,3,1,1))*0.5D0
      S(3,3,1,1)=S(1,1,3,3)
C
      S(2,2,3,3)=(S(2,2,3,3)+S(3,3,2,2))*0.5D0
      S(3,3,2,2)=S(2,2,3,3)
C
      S(1,2,1,2)=(S(1,2,1,2)+S(1,2,2,1)+S(2,1,1,2)+S(2,1,2,1))*0.25D0
      S(1,2,2,1)=S(1,2,1,2)
      S(2,1,1,2)=S(1,2,1,2)
      S(2,1,2,1)=S(1,2,1,2)
C
      S(1,3,1,3)=(S(1,3,1,3)+S(1,3,3,1)+S(3,1,1,3)+S(3,1,3,1))*0.25D0
      S(1,3,3,1)=S(1,3,1,3)
      S(3,1,1,3)=S(1,3,1,3)
      S(3,1,3,1)=S(1,3,1,3)
C
      S(2,3,2,3)=(S(2,3,2,3)+S(2,3,3,2)+S(3,2,2,3)+S(3,2,3,2))*0.25D0
      S(2,3,3,2)=S(2,3,2,3)
      S(3,2,2,3)=S(2,3,2,3)
      S(3,2,3,2)=S(2,3,2,3)
C
      S(1,1,1,2)=(S(1,1,1,2)+S(1,1,2,1)+S(1,2,1,1)+S(2,1,1,1))*0.25D0
      S(1,1,2,1)=S(1,1,1,2)
      S(1,2,1,1)=S(1,1,1,2)
      S(2,1,1,1)=S(1,1,1,2)
C
      S(1,1,1,3)=(S(1,1,1,3)+S(1,1,3,1)+S(1,3,1,1)+S(3,1,1,1))*0.25D0
      S(1,1,3,1)=S(1,1,1,3)
      S(1,3,1,1)=S(1,1,1,3)
      S(3,1,1,1)=S(1,1,1,3)
C
      S(1,1,2,3)=(S(1,1,2,3)+S(1,1,3,2)+S(2,3,1,1)+S(3,2,1,1))*0.25D0
      S(1,1,3,2)=S(1,1,2,3)
      S(2,3,1,1)=S(1,1,2,3)
      S(3,2,1,1)=S(1,1,2,3)
C
      S(2,2,1,2)=(S(2,2,1,2)+S(2,2,2,1)+S(1,2,2,2)+S(2,1,2,2))*0.25D0
      S(2,2,2,1)=S(2,2,1,2)
      S(1,2,2,2)=S(2,2,1,2)
      S(2,1,2,2)=S(2,2,1,2)
C
      S(2,2,1,3)=(S(2,2,1,3)+S(2,2,3,1)+S(1,3,2,2)+S(3,1,2,2))*0.25D0
      S(2,2,3,1)=S(2,2,1,3)
      S(1,3,2,2)=S(2,2,1,3)
      S(3,1,2,2)=S(2,2,1,3)
C
      S(2,2,2,3)=(S(2,2,2,3)+S(2,2,3,2)+S(2,3,2,2)+S(3,2,2,2))*0.25D0
      S(2,2,3,2)=S(2,2,2,3)
      S(2,3,2,2)=S(2,2,2,3)
      S(3,2,2,2)=S(2,2,2,3)
C
      S(3,3,1,2)=(S(3,3,1,2)+S(3,3,2,1)+S(1,2,3,3)+S(2,1,3,3))*0.25D0
      S(3,3,2,1)=S(3,3,1,2)
      S(1,2,3,3)=S(3,3,1,2)
      S(2,1,3,3)=S(3,3,1,2)
C
      S(3,3,1,3)=(S(3,3,1,3)+S(3,3,3,1)+S(1,3,3,3)+S(3,1,3,3))*0.25D0
      S(3,3,3,1)=S(3,3,1,3)
      S(1,3,3,3)=S(3,3,1,3)
      S(3,1,3,3)=S(3,3,1,3)
C
      S(3,3,2,3)=(S(3,3,2,3)+S(3,3,3,2)+S(3,2,3,3)+S(2,3,3,3))*0.25D0
      S(3,3,3,2)=S(3,3,2,3)
      S(3,2,3,3)=S(3,3,2,3)
      S(2,3,3,3)=S(3,3,2,3)
C
      S(1,2,1,3)=(S(1,2,1,3)+S(1,2,3,1)+S(2,1,1,3)+S(2,1,3,1)
     $+S(1,3,1,2)+S(1,3,2,1)+S(3,1,1,2)+S(3,1,2,1))*0.125D0
      S(1,2,3,1)=S(1,2,1,3)
      S(2,1,1,3)=S(1,2,1,3)
      S(2,1,3,1)=S(1,2,1,3)
      S(1,3,1,2)=S(1,2,1,3)
      S(1,3,2,1)=S(1,2,1,3)
      S(3,1,1,2)=S(1,2,1,3)
      S(3,1,2,1)=S(1,2,1,3)
C
      S(1,2,2,3)=(S(1,2,2,3)+S(1,2,3,2)+S(2,1,2,3)+S(2,1,3,2)
     $+S(2,3,1,2)+S(2,3,2,1)+S(3,2,1,2)+S(3,2,2,1))*0.125D0
      S(1,2,3,2)=S(1,2,2,3)
      S(2,1,2,3)=S(1,2,2,3)
      S(2,1,3,2)=S(1,2,2,3)
      S(2,3,1,2)=S(1,2,2,3)
      S(2,3,2,1)=S(1,2,2,3)
      S(3,2,1,2)=S(1,2,2,3)
      S(3,2,2,1)=S(1,2,2,3)
C
      S(1,3,2,3)=(S(1,3,2,3)+S(1,3,3,2)+S(3,1,2,3)+S(3,1,3,2)
     $+S(2,3,1,3)+S(2,3,3,1)+S(3,2,1,3)+S(3,2,3,1))*0.125D0
      S(1,3,3,2)=S(1,3,2,3)
      S(3,1,2,3)=S(1,3,2,3)
      S(3,1,3,2)=S(1,3,2,3)
      S(2,3,1,3)=S(1,3,2,3)
      S(2,3,3,1)=S(1,3,2,3)
      S(3,2,1,3)=S(1,3,2,3)
      S(3,2,3,1)=S(1,3,2,3)
C
      RETURN
      END
C =====================================================================
C ========================= J I J K L =================================
C =====================================================================
C
      SUBROUTINE JIJKL(DAMA)
C
C
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON/JIJKL1/XJIJKL(3,3,3,3)
C
      FACT = 2.D0*(1.D0-DAMA)
C
      XJIJKL(1 , 1 , 1 , 1) = 1.D0
      XJIJKL(1 , 1 , 2 , 2) = DAMA
      XJIJKL(1 , 1 , 3 , 3) = DAMA
      XJIJKL(2 , 2 , 1 , 1) = DAMA
      XJIJKL(2 , 2 , 2 , 2) = 1.D0
      XJIJKL(2 , 2 , 3 , 3) = DAMA
      XJIJKL(3 , 3 , 1 , 1) = DAMA
      XJIJKL(3 , 3 , 2 , 2) = DAMA
      XJIJKL(3 , 3 , 3 , 3) = 1.D0
      XJIJKL(1 , 2 , 1 , 2) = FACT
      XJIJKL(2 , 1 , 2 , 1) = FACT
      XJIJKL(1 , 3 , 1 , 3) = FACT
      XJIJKL(3 , 1 , 3 , 1) = FACT
      XJIJKL(2 , 3 , 2 , 3) = FACT
      XJIJKL(3 , 2 , 3 , 2) = FACT
      XJIJKL(1 , 2 , 2 , 1) = FACT
      XJIJKL(2 , 1 , 1 , 2) = FACT
      XJIJKL(1 , 3 , 3 , 1) = FACT
      XJIJKL(3 , 1 , 1 , 3) = FACT
      XJIJKL(2 , 3 , 3 , 2) = FACT
      XJIJKL(3 , 2 , 2 , 3) = FACT
C
      RETURN
      END
C ====================================================================
C ========================= G D E R ==================================
C ====================================================================
C
      SUBROUTINE GDER(S)
C
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON/GDER1/GS(3,3),GPHI(3,3)
      COMMON/AMIJK1/XMIJKL(3,3,3,3)
      COMMON/JIJKL1/XJIJKL(3,3,3,3)
      COMMON/MDPHI1/XMPHI(3,3,3,3,3,3)
      DIMENSION S(3,3)
      DIMENSION CST1(3,3,3,3,3,3),CST2(3,3,3,3)
      DIMENSION CST3(3,3,3,3),CST4(3,3,3,3),CST5(3,3)
C
      DO 10 K1=1,3
      DO 10 K2=1,3
      DO 10 K3=1,3
      DO 10 K4=1,3
      DO 10 K5=1,3
      DO 10 K6=1,3
      CST1(K1,K2,K3,K4,K5,K6)=0.D0
      DO 10 K7=1,3
      DO 10 K8=1,3
      CST1(K1,K2,K3,K4,K5,K6)=CST1(K1,K2,K3,K4,K5,K6)
     $   +XJIJKL(K7,K8,K1,K2)*XMPHI(K7,K8,K3,K4,K5,K6)
  10  CONTINUE
C
      DO 20 K1=1,3
      DO 20 K2=1,3
      DO 20 K5=1,3
      DO 20 K6=1,3
      CST2(K1,K2,K5,K6)=0.D0
      DO 20 K3=1,3
      DO 20 K4=1,3
      CST2(K1,K2,K5,K6)= CST2(K1,K2,K5,K6)
     $   +CST1(K1,K2,K3,K4,K5,K6)*S(K3,K4)
  20  CONTINUE
C
      DO 30 K5=1,3
      DO 30 K6=1,3
      DO 30 K9=1,3
      DO 30 K10=1,3
      CST3(K5,K6,K9,K10)=0.D0
      DO 30 K1=1,3
      DO 30 K2=1,3
      CST3(K5,K6,K9,K10)= CST3(K5,K6,K9,K10)
     $   +CST2(K1,K2,K5,K6)*XMIJKL(K1,K2,K9,K10)
  30  CONTINUE
C
      DO 40 K5=1,3
      DO 40 K6=1,3
      GPHI(K5,K6)=0.D0
      DO 40 K9=1,3
      DO 40 K10=1,3
      GPHI(K5,K6)=GPHI(K5,K6)+CST3(K5,K6,K9,K10)*S(K9,K10)
  40  CONTINUE
C
      DO 50 K1=1,3
      DO 50 K2=1,3
      DO 50 K3=1,3
      DO 50 K4=1,3
      CST4(K1,K2,K3,K4)=0.D0
      DO 50 K5=1,3
      DO 50 K6=1,3
      CST4(K1,K2,K3,K4)= CST4(K1,K2,K3,K4)
     $   +XJIJKL(K1,K2,K5,K6)*XMIJKL(K5,K6,K3,K4)
  50  CONTINUE
C
      DO 60 K1=1,3
      DO 60 K2=1,3
      CST5(K1,K2)=0.D0
      DO 60 K3=1,3
      DO 60 K4=1,3
      CST5(K1,K2)=CST5(K1,K2)+CST4(K1,K2,K3,K4)*S(K3,K4)
  60  CONTINUE
C
      DO 70 K7=1,3
      DO 70 K8=1,3
      GS(K7,K8)=0.D0
      DO 70 K1=1,3
      DO 70 K2=1,3
      GS(K7,K8)=GS(K7,K8)+CST5(K1,K2)*XMIJKL(K1,K2,K7,K8)
  70  CONTINUE
C
      RETURN
      END
C
C =====================================================================
C ======================= A I I N V ===================================
C =====================================================================
      SUBROUTINE AIINV(A)
      IMPLICIT REAL*8 (A-H,O-Z)                                         00070011
      DIMENSION A(6,6)                                                  00080011
C                                                                       00090011
      N=6                                                               00100011
C                                                                       00200011
      DO 26 I=1,N                                                       00260011
      CON=A(I,I)                                                        00270011
      DO 2 J=1,N                                                        00280011
    2 A(I,J)=A(I,J)/CON                                                 00290011
      A(I,I)=1.D0/CON                                                   00300011
      DO 26 J=1,N                                                       00310011
      IF(J-I) 4,26,4                                                    00320011
    4 DO 36 K=1,N                                                       00330011
      IF(K-I) 5,36,5                                                    00340011
    5 A(J,K)=A(J,K)-A(I,K)*A(J,I)                                       00350011
   36 CONTINUE                                                          00360011
      A(J,I)=-A(I,I)*A(J,I)                                             00370011
   26 CONTINUE                                                          00380011
C                                                                       00440011
      RETURN                                                            00450011
      END                                                               00460011
C
C ==========================================================
C ====================== CONVTM ============================
C ==========================================================
C
      SUBROUTINE CONVTM(T,X)
      REAL*8 T,X
      DIMENSION T(3,3,3,3),X(6,6)
C
      X(1,1)=T(1,1,1,1)
      X(1,2)=T(1,1,2,2)
      X(1,3)=T(1,1,3,3)
      X(1,4)=T(1,1,1,2)
      X(1,5)=T(1,1,2,3)
      X(1,6)=T(1,1,1,3)
C
      X(2,1)=T(2,2,1,1)
      X(2,2)=T(2,2,2,2)
      X(2,3)=T(2,2,3,3)
      X(2,4)=T(2,2,1,2)
      X(2,5)=T(2,2,2,3)
      X(2,6)=T(2,2,1,3)
C
      X(3,1)=T(3,3,1,1)
      X(3,2)=T(3,3,2,2)
      X(3,3)=T(3,3,3,3)
      X(3,4)=T(3,3,1,2)
      X(3,5)=T(3,3,2,3)
      X(3,6)=T(3,3,1,3)
C
      X(4,1)=T(1,2,1,1)
      X(4,2)=T(1,2,2,2)
      X(4,3)=T(1,2,3,3)
      X(4,4)=T(1,2,1,2)
      X(4,5)=T(1,2,2,3)
      X(4,6)=T(1,2,1,3)
C
      X(5,1)=T(2,3,1,1)
      X(5,2)=T(2,3,2,2)
      X(5,3)=T(2,3,3,3)
      X(5,4)=T(2,3,1,2)
      X(5,5)=T(2,3,2,3)
      X(5,6)=T(2,3,1,3)
C
      X(6,1)=T(1,3,1,1)
      X(6,2)=T(1,3,2,2)
      X(6,3)=T(1,3,3,3)
      X(6,4)=T(1,3,1,2)
      X(6,5)=T(1,3,2,3)
      X(6,6)=T(1,3,1,3)
C
C
      RETURN
      END
C
C ============================================================
C ===================== CONVMT ===============================
C ============================================================
C
      SUBROUTINE CONVMT(X,T)
      REAL*8 X,T
      DIMENSION X(6,6),T(3,3,3,3)
C
      T(1,1,1,1)=X(1,1)
      T(1,1,2,2)=X(1,2)
      T(1,1,3,3)=X(1,3)
      T(1,1,1,2)=X(1,4)*0.5D0
      T(1,1,2,1)=X(1,4)*0.5D0
      T(1,1,2,3)=X(1,5)*0.5D0
      T(1,1,3,2)=X(1,5)*0.5D0
      T(1,1,1,3)=X(1,6)*0.5D0
      T(1,1,3,1)=X(1,6)*0.5D0
C
      T(2,2,1,1)=X(2,1)
      T(2,2,2,2)=X(2,2)
      T(2,2,3,3)=X(2,3)
      T(2,2,1,2)=X(2,4)*0.5D0
      T(2,2,2,1)=X(2,4)*0.5D0
      T(2,2,2,3)=X(2,5)*0.5D0
      T(2,2,3,2)=X(2,5)*0.5D0
      T(2,2,1,3)=X(2,6)*0.5D0
      T(2,2,3,1)=X(2,6)*0.5D0
C
      T(3,3,1,1)=X(3,1)
      T(3,3,2,2)=X(3,2)
      T(3,3,3,3)=X(3,3)
      T(3,3,1,2)=X(3,4)*0.5D0
      T(3,3,2,1)=X(3,4)*0.5D0
      T(3,3,2,3)=X(3,5)*0.5D0
      T(3,3,3,2)=X(3,5)*0.5D0
      T(3,3,1,3)=X(3,6)*0.5D0
      T(3,3,3,1)=X(3,6)*0.5D0
C
      T(1,2,1,1)=X(4,1)*0.5D0
      T(1,2,2,2)=X(4,2)*0.5D0
      T(1,2,3,3)=X(4,3)*0.5D0
      T(1,2,1,2)=X(4,4)*0.25D0
      T(1,2,2,1)=X(4,4)*0.25D0
      T(1,2,2,3)=X(4,5)*0.25D0
      T(1,2,3,2)=X(4,5)*0.25D0
      T(1,2,1,3)=X(4,6)*0.25D0
      T(1,2,3,1)=X(4,6)*0.25D0
C
      T(2,1,1,1)=X(4,1)*0.5D0
      T(2,1,2,2)=X(4,2)*0.5D0
      T(2,1,3,3)=X(4,3)*0.5D0
      T(2,1,1,2)=X(4,4)*0.25D0
      T(2,1,2,1)=X(4,4)*0.25D0
      T(2,1,2,3)=X(4,5)*0.25D0
      T(2,1,3,2)=X(4,5)*0.25D0
      T(2,1,1,3)=X(4,6)*0.25D0
      T(2,1,3,1)=X(4,6)*0.25D0
C
      T(2,3,1,1)=X(5,1)*0.5D0
      T(2,3,2,2)=X(5,2)*0.5D0
      T(2,3,3,3)=X(5,3)*0.5D0
      T(2,3,1,2)=X(5,4)*0.25D0
      T(2,3,2,1)=X(5,4)*0.25D0
      T(2,3,2,3)=X(5,5)*0.25D0
      T(2,3,3,2)=X(5,5)*0.25D0
      T(2,3,1,3)=X(5,6)*0.25D0
      T(2,3,3,1)=X(5,6)*0.25D0
C
      T(3,2,1,1)=X(5,1)*0.5D0
      T(3,2,2,2)=X(5,2)*0.5D0
      T(3,2,3,3)=X(5,3)*0.5D0
      T(3,2,1,2)=X(5,4)*0.25D0
      T(3,2,2,1)=X(5,4)*0.25D0
      T(3,2,2,3)=X(5,5)*0.25D0
      T(3,2,3,2)=X(5,5)*0.25D0
      T(3,2,1,3)=X(5,6)*0.25D0
      T(3,2,3,1)=X(5,6)*0.25D0
C
      T(1,3,1,1)=X(6,1)*0.5D0
      T(1,3,2,2)=X(6,2)*0.5D0
      T(1,3,3,3)=X(6,3)*0.5D0
      T(1,3,1,2)=X(6,4)*0.25D0
      T(1,3,2,1)=X(6,4)*0.25D0
      T(1,3,2,3)=X(6,5)*0.25D0
      T(1,3,3,2)=X(6,5)*0.25D0
      T(1,3,1,3)=X(6,6)*0.25D0
      T(1,3,3,1)=X(6,6)*0.25D0
C
      T(3,1,1,1)=X(6,1)*0.5D0
      T(3,1,2,2)=X(6,2)*0.5D0
      T(3,1,3,3)=X(6,3)*0.5D0
      T(3,1,1,2)=X(6,4)*0.25D0
      T(3,1,2,1)=X(6,4)*0.25D0
      T(3,1,2,3)=X(6,5)*0.25D0
      T(3,1,3,2)=X(6,5)*0.25D0
      T(3,1,1,3)=X(6,6)*0.25D0
      T(3,1,3,1)=X(6,6)*0.25D0
C
      RETURN
      END
C
C =====================================================================
C ===========                    E N D   O F                  =========
C =========== L I N E A R    E L A S T I C I T Y    M O D E L =========
C ===========   W I T H   D A M A G E    M E C H A N I C S    =========
C =====================================================================
C
C =====================================================================
C ======================== P L A S T ==================================
C =====================================================================
C
      SUBROUTINE PLAST(ELNUM,ELEM_TYPE,MATNUM,INTGPN,STRS_STRN_REL,
     .                 I_OUT,EVAL_STIFF_OR_EVAL_STRESS)
      IMPLICIT NONE
      INTEGER STRS_STRN_REL,I_OUT
      INTEGER EVAL_STIFF_OR_EVAL_STRESS,EVAL_STIFF
      PARAMETER (EVAL_STIFF=0)
      INTEGER ELNUM,ELEM_TYPE,INTGPN,MATNUM,IEND
C
      IF(ELEM_TYPE.GT.300) THEN
        IEND=6
      ELSE
        IEND=4
      ENDIF
      IF (EVAL_STIFF_OR_EVAL_STRESS.EQ.EVAL_STIFF) THEN
        CALL MISES1(ELNUM,ELEM_TYPE,MATNUM,INTGPN,STRS_STRN_REL,IEND)
      ELSE
        CALL MISES2(ELNUM,ELEM_TYPE,MATNUM,INTGPN,STRS_STRN_REL,IEND)
      END IF
C
      END
C
C =====================================================================
C ======================== M I S E S ==================================
C =====================================================================
C
      SUBROUTINE MISES
C
C =====================================================================
C I                                                                   I
C I   P R O G R A M:                                                  I
C I                                                                   I
C I      PROGRAM 'MISES' IS THE CONTROL UNIT FOR CALCULATION OF THE   I
C I      ELASTOPLASTIC STRESS-STRAIN STIFFNESS MATRIX.                I
C I                                                                   I
C I                                                                   I
C =====================================================================
C
      IMPLICIT NONE
      INTEGER MAX_ELEMENTS,MAX_MAT_TYPE,MNNDF
      INTEGER STRS_STRN_REL
      PARAMETER (MAX_ELEMENTS=400,MAX_MAT_TYPE=10,MNNDF=3)
      INTEGER ELNUM,ELEM_TYPE,IDIM,INCREM,INCREMENTS,INTGPN,ITEMP
      INTEGER ITERATIONS,K1,K2,K3,K4,LDEV,LDEV1,LDEV2,LDEV3,LDEV4
      INTEGER LDEVST,MATNUM,NELEM,NINODE,NIT,NNDF,NNODES,IYIEL
      INTEGER KINE_CTRL,P2X,IEND
      LOGICAL LINEAR,SYMMETRIC,IYIELD,INITIAL_CORRECTION
      REAL*8 NUX,NUY,NUZ,LAMDOT,MUDOT,KINEMATIC_CONST,ISOTROPIC_CONST
      REAL*8 CST,POISS,SYIELD,WORK,YOUNG,AD
      REAL*8 DEP,DEPM,EX,EY,EZ,P1X,P1Y,P1Z,P2Y,CQBARM,FLAMDOT
      REAL*8 P2Z,STRN,STRS,TAU(3,3),TAU0(3,3),ALPHA(3,3),FS,FA,FK
      REAL*8 F0,F1,F2,DEN,R,R0,R1,DTAU(3,3),TAU2(3,3),DTAU2(3,3)
      REAL*8 SIGMA(3,3),SIGMA2(3,3),BETA(3,3),SDOT2(3,3)
      REAL*8 EDOT(3,3),SF(3,3),EDOTEL(3,3),EDOTPL(3,3),DELAS(6)
      REAL*8 STRESS(6),STRAIN(6),CENTER(6),STRELA(6),DE(6),SDOT(3,3)
      REAL*8 FFYIELD,FCQBARM,ZERO,HALF,ONE,TWO,THREE,ffinal
      COMMON/DEVICE/LDEV1,LDEV2,LDEV3,LDEV4,LDEV,LDEVST
      COMMON/CONTR1/INCREM,NIT
      COMMON/ELSTR1/STRN(6)
      COMMON/ELSTR2/STRS(6)
      COMMON/ADMAT1/AD(3,3,3,3)
      COMMON/PLAST1/IYIEL(MAX_ELEMENTS)
      COMMON/FDER1/FS(3,3),FA(3,3),FK
      COMMON/MATER1/DEP(6,6)
      COMMON/ELPLD1/DEPM(3,3,3,3)
      COMMON/INPUT8/NNODES,NELEM,NNDF,INCREMENTS,ITERATIONS,LINEAR,
     .              SYMMETRIC,IDIM,NINODE
      COMMON/INPUT5/NUX(MAX_MAT_TYPE),NUY(MAX_MAT_TYPE),
     .              NUZ(MAX_MAT_TYPE),EX(MAX_MAT_TYPE),
     .              EY(MAX_MAT_TYPE),EZ(MAX_MAT_TYPE),
     .              P1X(MAX_MAT_TYPE),P1Y(MAX_MAT_TYPE),
     .              P1Z(MAX_MAT_TYPE),P2X(MAX_MAT_TYPE),
     .              P2Y(MAX_MAT_TYPE),P2Z(MAX_MAT_TYPE)
      COMMON/XXX16/SYIELD
C
      DATA ZERO,HALF,ONE,TWO,THREE /0.0D0,0.5D0,1.0D0,2.0D0,3.0D0/
C
C ================= E N T R Y    M I S E S 1 ==========================
C
      ENTRY MISES1(ELNUM,ELEM_TYPE,MATNUM,INTGPN,STRS_STRN_REL,IEND)
      IYIELD = .FALSE.
      IF (INCREM.GT.1) THEN
        IF (NIT.EQ.1) THEN
          READ(LDEV1) STRESS,STRAIN,STRELA,CENTER,WORK,IYIELD
        ELSE
          READ(LDEV2) STRESS,STRAIN,STRELA,CENTER,WORK,IYIELD
        END IF
        BACKSPACE(UNIT=LDEV)
      END IF
      IF (IYIELD) THEN
C
C --- GET THE MATERIAL PARAMETERS
C
        KINE_CTRL = P2X( MATNUM )
        ISOTROPIC_CONST = P1Y( MATNUM )
        SYIELD = P1Z( MATNUM )
        KINEMATIC_CONST = P1X( MATNUM )
        YOUNG = EX( MATNUM )
        POISS = NUX( MATNUM )
C
C --- CALCULATION OF THE USEFUL MATRICES
C
        CALL TENSOR(ELEM_TYPE,STRESS,SIGMA,ONE)
        CALL TENSOR(ELEM_TYPE,CENTER,BETA,ONE)
        CALL DSDEVIATOR(SIGMA,TAU)
        CALL DSDEVIATOR(BETA,ALPHA)
C
C --- CALCULATION OF THE FOURTH ORDER ELASTIC STIFFNESS MATRIX
C
        CALL ADMAT(YOUNG,POISS)
C
C --- CALCULATION OF THE PARTIAL DERIVATIVE OF THE YIELD FUNCTION
C --- F WITH RESPECT TO THE <STRESS>.
C
        CALL SFDER(TAU,ALPHA,KINE_CTRL,ISOTROPIC_CONST)
C
C --- CALCULATION OF THE ELASTOPLASTIC STIFFNESS MATRIX
C
        CQBARM=FCQBARM(TAU,ALPHA,KINEMATIC_CONST,KINE_CTRL)
        CALL SDEPMM(CQBARM)
C
C --- CONVERSION OF THE FORTH ORDER STIFFNESS TENSOR TO A SECOND
C --- ORDER TENSOR
C
        CALL CONVER(DEPM,DEP,STRS_STRN_REL,ELEM_TYPE)
      ELSE
        CALL DELAST(ELEM_TYPE,MATNUM,STRS_STRN_REL)
      END IF
      RETURN
C
C ==================== E N T R Y    M I S E S 2 =======================
C
      ENTRY MISES2(ELNUM,ELEM_TYPE,MATNUM,INTGPN,STRS_STRN_REL,IEND)
      IF (INCREM.GT.1) THEN
        READ(LDEV1) STRESS,STRAIN,STRELA,CENTER,WORK,IYIELD,
     .              INITIAL_CORRECTION
      ELSE
        DO K1 = 1 , IEND
          STRAIN( K1 ) = ZERO
          STRESS( K1 ) = ZERO
          CENTER( K1 ) = ZERO
          STRELA( K1 ) = ZERO
        END DO
        WORK = ZERO
      END IF
C
C --- GET THE MATERIAL PARAMETERS
C
      KINE_CTRL=P2X(MATNUM)
      ISOTROPIC_CONST=P1Y(MATNUM)
      SYIELD=P1Z(MATNUM)
      KINEMATIC_CONST=P1X(MATNUM)
      YOUNG = EX( MATNUM )
      POISS = NUX( MATNUM )
C
C --- CALCULATION OF THE STRAIN INCREMENT
C
      DO K1 = 1 , IEND
        DE( K1 ) = STRN( K1 ) - STRAIN( K1 )
      END DO
C
C --- CALCULATION OF THE USEFUL TENSORS
C
      CALL TENSOR(ELEM_TYPE,STRESS,SIGMA,ONE)
      CALL TENSOR(ELEM_TYPE,DE,EDOT,HALF)
      CALL TENSOR(ELEM_TYPE,CENTER,BETA,ONE)
C
C --- CALCULATION OF THE FOURTH ORDER ELASTIC STIFFNESS MATRIX
C
      CALL ADMAT(YOUNG,POISS)
      CALL DAijkl_Bkl(AD,EDOT,SDOT)
C
      CALL DAij_PLUS_Bij(SIGMA,SDOT,SF)
      print*,'sf(1,1)=',sf(1,1)
      print*,'sigma(1,1)=',sigma(1,1)
      print*,'sdot(1,1)=',sdot(1,1)
      CALL DSDEVIATOR(SIGMA,TAU0)
      CALL DSDEVIATOR(SDOT,DTAU)
      CALL DSDEVIATOR(SF,TAU)
      CALL DSDEVIATOR(BETA,ALPHA)
C
C --- CALCULATION OF THE YIELD FUNCTION FOR THE TRIAL STRESS
C
      F1=FFYIELD(TAU,ALPHA,KINE_CTRL,ISOTROPIC_CONST,WORK)
      print*,'F1=',f1
      IF (F1.LE.ZERO) THEN
        DO K1=1,IEND
          STRELA(K1)=STRELA(K1)+DE(K1)
        END DO
        DO K2=1,3
          DO K1=1,3
            SIGMA(K1,K2)=SF(K1,K2)
          END DO
        END DO
        IYIELD = .FALSE.
        INITIAL_CORRECTION=.TRUE.
      ELSE IF(F1.GT.ZERO) THEN
        IF(INITIAL_CORRECTION) THEN
          F0=FFYIELD(TAU0,ALPHA,KINE_CTRL,ISOTROPIC_CONST,WORK)
          print*,'F0=',f0
          R0=-F0/(F1-F0)   
          print*,'R0=',R0
          CALL Dscalar_multiply_Aij(SDOT,SDOT2,R0)
          print*,'sigma(1,1)=',sigma(1,1)
          print*,'sdot(1,1)=',sdot(1,1)
          print*,'sdot2(1,1)=',sdot2(1,1)
          CALL DAij_plus_Bij(SIGMA,SDOT2,SIGMA2)
          CALL DSDEVIATOR(SIGMA2,TAU2)
          print*,'sigma(1,1)=',sigma(1,1)
          print*,'sigma2(1,1)=',sigma2(1,1)
          print*,'tau2(1,1)=',tau2(1,1)
          print*,'sdot2(1,1)=',sdot2(1,1)
          CALL DSDEVIATOR(SDOT2,DTAU2)
          INITIAL_CORRECTION=.FALSE.
        ELSE
          R0=ZERO
          CALL DSDEVIATOR(SF,TAU2)
          CALL DSDEVIATOR(SDOT,DTAU2)
        ENDIF
        F2=FFYIELD(TAU2,ALPHA,KINE_CTRL,ISOTROPIC_CONST,WORK)
        print*,'F2=',f2
        CALL SFDER(TAU2,ALPHA,KINE_CTRL,ISOTROPIC_CONST)
        CALL DAij_Bij(FS,DTAU2,DEN)
        R1=-F2/DEN
        R=R0+R1
        CALL Dscalar_multiply_Aij(SDOT,SDOT,R)
        CALL DAij_plus_Bij(SIGMA,SDOT,SIGMA)
        CALL DSDEVIATOR(SIGMA,TAU)
        fFinal=FFYIELD(TAU,ALPHA,KINE_CTRL,ISOTROPIC_CONST,WORK)
        print*,'FFinal=',ffinal
        CALL SFDER(TAU,ALPHA,KINE_CTRL,ISOTROPIC_CONST)
        CQBARM=FCQBARM(TAU,ALPHA,KINEMATIC_CONST,KINE_CTRL)
        LAMDOT=FLAMDOT(EDOT)/CQBARM
        MUDOT=THREE*KINEMATIC_CONST*LAMDOT
        DO K2 = 1 , 3
          DO K1 = 1 , 3
            EDOTPL(K1 , K2) = LAMDOT*FS(K1 , K2)
            EDOTEL(K1 , K2) = EDOT(K1 , K2) - EDOTPL(K1 , K2)
            BETA(K1,K2 ) = BETA(K1,K2)+(SIGMA(K1,K2)-BETA(K1,K2))*MUDOT
          END DO
        END DO
        DO K2 = 1 , 3
          DO K1 = 1 , 3
            CST = ZERO
            DO K4 = 1 , 3
              DO K3 = 1 , 3
                CST = CST + AD(K1 , K2 , K3 , K4)*EDOTEL(K3 , K4)
              END DO
            END DO
            WORK=WORK+(SIGMA(K1,K2)+HALF*CST)*EDOTPL(K1,K2)
         END DO
        END DO
        CALL VECTOR(ELEM_TYPE,EDOTEL,DELAS,TWO)
        DO K1 = 1 , IEND
          STRELA( K1 ) = STRELA( K1 ) + DELAS( K1 )
        END DO
        IYIELD = .TRUE.
      END IF
C
C       DEFINE THE 'IYIEL' VECTOR FOR FUTURE PLOTTING
C
      IF (IYIELD) THEN
        ITEMP = IBSET(IYIEL( ELNUM ) , INTGPN)
        IYIEL( ELNUM ) = ITEMP
      ELSE
        ITEMP = IBCLR(IYIEL( ELNUM ) , INTGPN)
        IYIEL( ELNUM ) = ITEMP
      END IF
      DO K1 = 1 , IEND
        STRAIN( K1 ) = STRN( K1 )
      END DO
      CALL VECTOR(ELEM_TYPE,SIGMA,STRS,ONE)
      CALL VECTOR(ELEM_TYPE,SIGMA,STRESS,ONE)
      CALL VECTOR(ELEM_TYPE,BETA,CENTER,ONE)
      WRITE(LDEV2) STRESS,STRAIN,STRELA,CENTER,WORK,IYIELD,
     .             INITIAL_CORRECTION
C
      END
C
C ====================================================================
C ========================= A D M A T ================================
C ====================================================================
C
      SUBROUTINE ADMAT(YOUNG,POISS)
C
C ====================================================================
C I                                                                  I
C I   P R O G R A M:                                                 I
C I                                                                  I
C I   'ADMAT' CALCULATES THE FOURTH ORDER ISOTROPIC ELASTIC          I
C I   STIFFNESS TENSOR.                                              I
C I                                                                  I
C I   A R G U M E N T     L I S T:                                   I
C I                                                                  I
C I   YOUNG  = YOUNGS MODULUS                                        I
C I   POISS  = POISSONS RATIO                                        I
C I                                                                  I
C ====================================================================
C
      IMPLICIT NONE
      REAL*8 ALAM,AMUE,POISS,YOUNG,AD,ONE,TWO
      COMMON/ADMAT1/AD(3,3,3,3)
C
      DATA ONE,TWO / 1.0D0,2.0D0 /
C
C --- ALAM =  THE LAMDA LAME CONSTANT
C --- AMUE =  THE MU LAME CONSTANT (THE SHEAR MODULUS G)
C
      CALL DIARRAY(AD,3,3,3,3,0,0,0)
      ALAM=POISS*YOUNG/((ONE+POISS)*(ONE-TWO*POISS))
      AMUE = YOUNG/(TWO*(ONE + POISS))
      AD(1 , 1 , 1 , 1) = ALAM + TWO*AMUE
      AD(1 , 1 , 2 , 2) = ALAM
      AD(1 , 1 , 3 , 3) = ALAM
      AD(2 , 2 , 1 , 1) = ALAM
      AD(2 , 2 , 2 , 2) = ALAM + TWO*AMUE
      AD(2 , 2 , 3 , 3) = ALAM
      AD(3 , 3 , 1 , 1) = ALAM
      AD(3 , 3 , 2 , 2) = ALAM
      AD(3 , 3 , 3 , 3) = ALAM + TWO*AMUE
      AD(1 , 2 , 1 , 2) = AMUE
      AD(2 , 1 , 2 , 1) = AMUE
      AD(1 , 3 , 1 , 3) = AMUE
      AD(3 , 1 , 3 , 1) = AMUE
      AD(2 , 3 , 2 , 3) = AMUE
      AD(3 , 2 , 3 , 2) = AMUE
      AD(1 , 2 , 2 , 1) = AMUE
      AD(2 , 1 , 1 , 2) = AMUE
      AD(1 , 3 , 3 , 1) = AMUE
      AD(3 , 1 , 1 , 3) = AMUE
      AD(2 , 3 , 3 , 2) = AMUE
      AD(3 , 2 , 2 , 3) = AMUE
C
      END
C
C ====================================================================
C ========================= FUNCTION FFYIELD =========================
C ====================================================================
C
C =====================================================================
C I                                                                   I
C I    FUNCTION TO COMPUTE THE YIELD FUNCTION F. THE ARRAYS SIGMA AND I
C I    BETA REPRESENT THE EFFECTIVE COMPONENTS OF EACH.               I
C I    THE PROGRAMMED YIELD FUNCTION IS AN EXTENDED FORM OF THE       I
C I    VON MISES YIELD CRITERION WITHOUT DAMAGE EFFECTS.              I
C I                                                                   I
C I    THE YIELD FUNCTION HAS THE FOLLOWING FORM.                     I
C I                                                                   I
C I        F = F1 + KINE_CTRL*F2 - ISOTROPIC_CONST*WORK - SYIELD**2   I
C I                                                                   I
C I    F1 = 3/2*SIGMA*SIGMA                                           I
C I    F2 = 3/2*(BETA*BETA - 2*SIGMA*BETA)                            I
C I    WORK = PLASTIC WORK                                            I
C I    KINE_CTRL = CONTROL PARAMETER FOR KINEMATIC HARDENING (0 OR 1) I
C I    ISOTROPIC_CONST = ISOTROPIC HARDENING PARAMETER                I
C I    SIGMA     IS THE COMPONENT OF TOTAL STRESS                     I
C I    BETA      IS THE COMPONENT OF BACKSTRESS                       I
C I    SYIELD    IS THE YIELD STRESS IN SIMPLE TENSION TEST           I
C I                                                                   I
C =====================================================================
C
      REAL*8 FUNCTION FFYIELD(SIGMA,BETA,KINE_CTRL,ISOTROPIC_CONST,WORK)
      IMPLICIT NONE
      INTEGER KINE_CTRL
      REAL*8 SYIELD,ISOTROPIC_CONST,WORK,F1,F2,CONST1,CONST2
      REAL*8 SIGMA(3,3),BETA(3,3),ZERO,ONEPFIVE,TWO
      COMMON/XXX16/SYIELD
C
      DATA ZERO,ONEPFIVE,TWO /0.0D0,1.5D0,2.0D0/
C
      CALL DAij_Bij(SIGMA,SIGMA,F1)
      F1=F1*ONEPFIVE
      F2=ZERO
      IF(KINE_CTRL.EQ.1) THEN
        CALL DAij_Bij(BETA,BETA,CONST1)
        CALL DAij_Bij(SIGMA,BETA,CONST2)
        F2=ONEPFIVE*(CONST1-TWO*CONST2)
      ENDIF
      FFYIELD=F1+F2-ISOTROPIC_CONST*WORK-SYIELD*SYIELD
C
      END
C
C ====================================================================
C ========================= SUBROUTINE SFDER =========================
C ====================================================================
C
      SUBROUTINE SFDER(SIGMA,BETA,KINE_CTRL,ISOTROPIC_CONST)
C
C ====================================================================
C I                                                                  I
C I    THIS SUBROUTINE CALCULATES THE DERIVATIVE OF "F" WRT          I
C I    <STRESS> AND PLASTIC WORK                                     I
C I                                                                  I
C I    SIGMA     IS THE COMPONENT OF TOTAL STRESS                    I
C I    BETA      IS THE COMPONENT OF BACKSTRESS                      I
C I    KINE_CTRL = CONTROL PARAMETER FOR KINEMATIC HARDENING (0 OR 1)I
C I    ISOTROPIC_CONST = ISOTROPIC HARDENING PARAMETER               I
C I    FS =  PARTIAL DERIVATIVE OF F WRT <STRESS>                    I
C I    FA =  PARTIAL DERIVATIVE OF F WRT <SHIFT TENSOR>              I
C I    FK =  PARTIAL DERIVATIVE OF F WRT PLASTIC WORK                I
C I                                                                  I
C ====================================================================
C
      IMPLICIT NONE
      INTEGER KINE_CTRL
      REAL*8 ZERO,ONE,THREE,FS,FA,FK,ISOTROPIC_CONST
      REAL*8 SIGMA(3,3),BETA(3,3),SUM12(3,3)
      COMMON/FDER1/FS(3,3),FA(3,3),FK
C
      DATA ZERO,ONE,THREE/0.0D0,1.0D0,3.0D0/
C
C EVALUATE PARTIAL DERIVATIVES OF YIELD FUNCTION
C
      IF(KINE_CTRL.EQ.1) THEN
        CALL DAij_MINUS_Bij(SIGMA,BETA,SUM12)
        CALL DSCALAR_MULTIPLY_Aij(SUM12,FS,THREE)
        CALL DSCALAR_MULTIPLY_Aij(FS,FA,-ONE)
      ELSE
        CALL DSCALAR_MULTIPLY_Aij(SIGMA,FS,THREE)
        CALL DSCALAR_MULTIPLY_Aij(FS,FA,ZERO)
      ENDIF
      FK=-ISOTROPIC_CONST
C
      END
C
C ====================================================================
C ========================= FUNCTION FLAMDOT =========================
C ====================================================================
C
C ====================================================================
C I                                                                  I
C I   FUNCTION FLAMDOT COMPUTES THE EXPRESSION FOR LAMBDA DOT.       I
C I                                                                  I
C ====================================================================
C
      REAL*8 FUNCTION FLAMDOT(DT_EPSILON)
C
      IMPLICIT NONE
      REAL*8 DT_EPSILON(3,3),SUM12(3,3),AD,FS,FA,FK,TMP
      COMMON/ADMAT1/AD(3,3,3,3)
      COMMON/FDER1/FS(3,3),FA(3,3),FK
C
      CALL DAijkl_Bkl(AD,DT_EPSILON,SUM12)
      CALL DAij_Bij(FS,SUM12,TMP)
      FLAMDOT=TMP
C
      END
C
C ====================================================================
C ======================== FUNCTION FCQBARM ==========================
C ====================================================================
C
C ====================================================================
C I                                                                  I
C I  FUNCTION FCQBARM COMPUTES THE CONSTANT EXPRESSION Qbar          I
C I  FOR THE MATRIX.                                                 I
C I                                                                  I
C ====================================================================
C
      REAL*8 FUNCTION FCQBARM(SIGMA,BETA,KINEMATIC_CONST,KINE_CTRL)
C
      IMPLICIT NONE
      INTEGER KINE_CTRL
      REAL*8 SIGMA(3,3),BETA(3,3),KINEMATIC_CONST
      REAL*8 SUMA,SUMB,SUMC,SUM12(3,3),FS,FA,FK,AD,ZERO
      COMMON/ADMAT1/AD(3,3,3,3)
      COMMON/FDER1/FS(3,3),FA(3,3),FK
C
      DATA ZERO /0.0D0/
C
      SUMC=ZERO
      IF(KINE_CTRL.EQ.1) THEN
        CALL DAij_MINUS_Bij(SIGMA,BETA,SUM12)
        CALL DAij_Bij(FA,SUM12,SUMC)
        CALL DAij_Bij(SUM12,FS,SUMA)
        CALL DAij_Bij(FS,FS,SUMB)
        SUMC=KINEMATIC_CONST*SUMC*SUMB/SUMA
      ENDIF
      CALL DAijkl_Bkl(AD,FS,SUM12)
      CALL DAij_Bij(FS,SUM12,SUMA)
      CALL DAij_Bij(SIGMA,FS,SUMB)
      SUMB=FK*SUMB
      FCQBARM=SUMA-SUMB-SUMC
C
      END
C=====================================================================
C=========================== SUBROUTINE SDEPMM =======================
C=====================================================================
C
      SUBROUTINE SDEPMM(CQBARM)
C
C ====================================================================
C I                                                                  I
C I SUBROUTINE SDEPMM COMPUTES THE ELASTO-PLASTIC STIFFNESS MATRIX   I
C I FOR THE MATRIX MATERIAL. THE COMPUTATION IS BASED ON A YIELD     I
C I FUNCTION THAT CAN HAVE KINEMATIC HARDENING AND/OR ISOTROPIC      I
C I HARDENING.                                                       I
C I                                                                  I
C ====================================================================
C
      IMPLICIT NONE
      REAL*8 CQBARM,AD,FS,FA,FK,SUM14(3,3,3,3),SUM12(3,3),SUM22(3,3)
      REAL*8 DEPM,ONE
      COMMON/ADMAT1/AD(3,3,3,3)
      COMMON/FDER1/FS(3,3),FA(3,3),FK
      COMMON/ELPLD1/DEPM(3,3,3,3)
      DATA ONE/1.0D0/
C
      CALL DAijkl_Bkl(AD,FS,SUM12)
      CALL DAijkl_Bij(AD,FS,SUM22)
      CALL DAij_Bkl(SUM22,SUM12,SUM14)
      CALL Dscalar_multiply_Aijkl(SUM14,SUM14,ONE/CQBARM)
      CALL DAijkl_MINUS_Bijkl(AD,SUM14,DEPM)
C
      END
C
C =====================================================================
C ===========               S T A R T   O F                   =========
C =========== F I N I T E    P L A S T I C I T Y    M O D E L =========
C ===========   W I T H    D A M A G E    M E C H A N I C S   =========
C =====================================================================
C ======================== P L D A M ==================================
C =====================================================================
      SUBROUTINE PLDAM(ELNUM,ITYPE,MATNUM,INTGPN,IFLAG,IOUT,ICODE,ICRK)
C
      INTEGER ELNUM
      CHARACTER*1 ICRK
C
      IF (ICODE.EQ.0) THEN
        CALL MIDAM1(ELNUM,ITYPE,MATNUM,INTGPN,IFLAG,IOUT)
      ELSE
        CALL MIDAM2(ELNUM,ITYPE,MATNUM,INTGPN,IFLAG,IOUT,ICRK)
      END IF
C
      RETURN
      END
C =====================================================================
C ======================== M I D A M ==================================
C =====================================================================
      SUBROUTINE MIDAM
C =====================================================================
C I                                                                   I
C I   P R O G R A M:                                                  I
C I                                                                   I
C I      PROGRAM 'MIDAM' IS THE CONTROL UNIT FOR CALCULATION OF THE   I
C I      ELASTOPLASTIC STRESS-STRAIN STIFFNESS MATRIX INCLUDING THE   I
C I      EFFECT OF DAMAGE.                                            I
C I                                                                   I
C =====================================================================
      IMPLICIT REAL*8 (A-H,O-Z)
      REAL*8 NUX,NUY,NUZ
      CHARACTER*48 CSTRN,CSTRS,CCENT,CSELA,CPHI,CDPHI
      CHARACTER*8 CWORK,CTABET
      CHARACTER*1 IYIELD,IY,ICRK
      INTEGER ELNUM
      COMMON/DEV1/LDEV5,LDEV6,LDEV7,LDEV8,LDEV9,LDEV10
      COMMON/DEVICE/LDEV1,LDEV2,LDEV3,LDEV4,LDEV,LDEVST
      COMMON/CONTR1/INCREM,NIT
      COMMON/ELSTR1/STRN(6)
      COMMON/ELSTR2/STRS(6)
      COMMON/ADMAT1/AD(3,3,3,3)
      COMMON/PLAST1/IYIEL(400)
      COMMON/FDER1/FJ,FK,FS(3,3),FE(3,3),FZ(3,3),FT(3,3)
      COMMON/FBDER1/FBJ,FBK,FBS(3,3),FBE(3,3),FBZ(3,3),FBT(3,3)
      COMMON/MATER1/DEP(6,6)
      COMMON/MATER2/GVECT(6)
      COMMON/EDBAR1/EDIJKL(3,3,3,3)
      COMMON/ELPLD1/DEPM(3,3,3,3)
      COMMON/ALAMU1/ALAM(3,3),AMU(3,3)
      COMMON/XOIJK1/OIJKL(3,3,3,3)
      COMMON/GDER1/GS(3,3),GPHI(3,3)
      COMMON/DEPMD1/PDIJKL(3,3,3,3)
      COMMON/TINVR1/OII(3,3,3,3)
      COMMON/EFFST1/XN(3,3,3,3),TAU(3,3),ZA(3,3),SB(3,3),TB(3,3),
     1   ZAB(3,3)
      COMMON/INPUT8/NNODES,NELEM,NNDF,NLINC,MNIT,IFLAG1,IFLAG2,IDIM,
     1              NINODE
      COMMON/INPUT5/NUX(10),NUY(10),NUZ(10),EX(10),EY(10),EZ(10),P1X(10)
     1              ,P1Y(10),P1Z(10),P2X(10),P2Y(10),P2Z(10)
      COMMON/INPUTJ/P3X(10),P4X(10),P5X(10)
      DIMENSION S0(3,3),C(3,3),Z(3,3),RR(3,3),E(3,3),DEL(3,3),ED(3,3),
     1          EDOT(3,3),SF(3,3),EDOTEL(3,3),EDOTPL(3,3),DELAS(6),
     2          STRESS(6),STRAIN(6),CENTER(6),STRELA(6),DE(6),SDOT(3,3),
     3          SS(6)
      DIMENSION PHI(6),DAMVAR(3,3),DDAMVA(3,3),DPHI(6)
      DIMENSION SDPHI(6)
      DIMENSION SV(6),DPLAS(6),SD(3,3),RDE(6),SS0(3,3)
      EQUIVALENCE (CSTRS,STRESS),(CSTRN,STRAIN),(CCENT,CENTER),
     1  (CSELA,STRELA),(CWORK,WORK),(CPHI,PHI),(CDPHI,DPHI),
     2  (CTABET,TABETA)
C
      DATA ((DEL(K1,K2),K1=1,3),K2=1,3)/1.D0,0.D0,0.D0,
     $  0.D0,1.D0,0.D0,0.D0,0.D0,1.D0/
C
C
C
      ENTRY MIDAM2(ELNUM,ITYPE,MATNUM,INTGPN,IFLAG,IOUT,ICRK)
C
      FACTOR=1.D0
      FACSUM=0.D0
      ICRK=' '
C
      IF (INCREM.GT.1) THEN
        READ(LDEV1,1000) CSTRS,CSTRN,CSELA,CPHI,CCENT,CWORK,IYIELD,
     $ CTABET,CDPHI
      ELSE
        DO 10 K1=1,6
        STRAIN(K1)=0.D0
        STRESS(K1)=0.D0
        CENTER(K1)=0.D0
        STRELA(K1)=0.D0
        DPHI(K1)=0.D0
  10    PHI(K1)=0.D0
        WORK=0.D0
        TABETA=0.D0
      END IF
C
C --- GET THE MATERIAL PARAMETERS
C
      BETA=P1X(MATNUM)
      C3=P1Y(MATNUM)
      SY=P1Z(MATNUM)
      DAMA=P3X(MATNUM)
      DBBET=P5X(MATNUM)
      YOUNG=EX(MATNUM)
      POISS=NUX(MATNUM)
C
      YP=(POISS*YOUNG)/((POISS*YOUNG)+3.D0*(1.D0-2.D0*POISS))
C
C --- CALCULATION OF THE STRAIN INCREMENT
C
      DO 15 K1=1,3
  15  DE(K1)=STRN(K1)-STRAIN(K1)
      STRN(4)=-YP*(STRN(1)+STRN(2))
      DE(4)=-YP*(DE(1)+DE(2))
C
C --- CALCULATION OF THE USEFULL TENSORS
C
      CALL TENSOR(ITYPE,STRESS,S0,1.D0)
      CALL TENSOR(ITYPE,STRESS,SS0,1.D0)
      CALL TENSOR(ITYPE,STRAIN,E,0.5D0)
      CALL TENSOR(ITYPE,DE,ED,0.5D0)
      CALL TENSOR(ITYPE,CENTER,Z,1.D0)
      CALL TENSOR(300,PHI,DAMVAR,1.D0)
C
C --- CALCULATION OF THE FOURTH ORDER ELASTIC STIFFNESS MATRIX
C
      CALL ADMAT(YOUNG,POISS)
      CALL JIJKL(DAMA)
      CALL AMIJK(PHI)
      CALL AMINV
      CALL EDBAR
      CALL CONVER(EDIJKL,DEP,IFLAG,ITYPE)
      CALL MDPHI(PHI)
C
      DO 20 K1=1,3
      DO 20 K2=1,3
 20   C(K1,K2)=2.D0*E(K1,K2)+DEL(K1,K2)
C
      DO 30 K1=1,3
      CST=0.D0
      DO 25 K2=1,3
 25   CST=CST+DEP(K1,K2)*DE(K2)
 30   SS(K1)=CST
      SS(4)=0.0
C
      CALL TENSOR(ITYPE,SS,SDOT,1.D0)
C
      DO 35 K1=1,3
      DO 35 K2=1,3
 35   EDOT(K1,K2)=ED(K1,K2)
C
C --- CALCULATION OF THE JACOBIAN OF DEFORMATION
C
  34  CALL DEFJAC(E,DEL,RR,DJAC)
C
C --- START OF THE INCREMENTATION LOOP
C --- CALCULATION OF THE TRIAL ELASTIC STRESS
C
      DO 40 K2=1,3
      DO 40 K1=1,3
  40  SF(K1,K2)=S0(K1,K2)+SDOT(K1,K2)
C
C --- CALCULATION OF THE YIELD FUNCTION FOR THE TRIAL ELASTIC STRESS
C
      CALL YIELD(SF,C,Z,WORK,DJAC,C3,SY,F,F1,F2)
C
      IF (F.LE.0.) THEN
        FACSUM=FACSUM+FACTOR
        DO 45 K1=1,6
 45     STRELA(K1)=STRELA(K1)+DE(K1)*FACTOR
        DO 50 K2=1,3
        DO 50 K1=1,3
        E(K1,K2)=E(K1,K2)+EDOT(K1,K2)
        C(K1,K2)=2.D0*E(K1,K2)+DEL(K1,K2)
 50     S0(K1,K2)=SF(K1,K2)
C
        IYIELD = ' '
C
      ELSE IF(F.GT.0.) THEN
        IF(FACTOR.EQ.1.) THEN
          FACTOR=0.1D0
C
          DO 55 K1=1,3
          DO 55 K2=1,3
          SDOT(K2,K1)=FACTOR*SDOT(K2,K1)
  55      EDOT(K2,K1)=FACTOR*ED(K2,K1)
          GO TO 34
        END IF
C
        FACSUM=FACSUM+FACTOR
C
        CALL EFFSTR(S0,Z)
        CALL FDER(S0,TAU,C,ZA,DJAC,F1,F2,C3)
        CALL FBDER(C,DJAC,F1,F2,C3)
        CALL ALAMU(SB,TB,ZAB,RR,DJAC,BETA)
C       CALL GDER(S0)
        CALL ELPLD(SB,TB,ZAB,RR,DJAC,BETA)
C
        DO 170 K=1,6
 170    SDPHI(K)=DPHI(K)*0.1D0
        SCALE=1.0D0
C
        CALL XZIJKL(S0,Z,BETA,SDPHI,SCALE)
        CALL XOIJK(S0,DBBET)
        CALL SYMMET(OIJKL)
        CALL TINVER(OIJKL,OII)
        CALL DEPMOD(ITYPE,IFLAG)
        CALL SYMMET(PDIJKL)
C
        ALAMDA=0.D0
        AMUDOT=0.D0
C
        DO 80 K2=1,3
        DO 80 K1=1,3
        AMUDOT=AMUDOT+AMU(K1,K2)*EDOT(K1,K2)
  80    ALAMDA=ALAMDA+ALAM(K1,K2)*EDOT(K1,K2)
C
        DO 85 K2=1,3
        DO 85 K1=1,3
        E(K1,K2)=E(K1,K2)+EDOT(K1,K2)
        C(K1,K2)=2.D0*E(K1,K2)+DEL(K1,K2)
        EDOTPL(K1,K2)=ALAMDA*FS(K1,K2)
        EDOTEL(K1,K2)=EDOT(K1,K2)-EDOTPL(K1,K2)
 85     Z(K1,K2)=Z(K1,K2)+(S0(K1,K2)-Z(K1,K2))*AMUDOT
C
        Z(3,3)=0.D0
        Z(1,3)=0.D0
        Z(3,1)=0.D0
        Z(3,2)=0.D0
        Z(2,3)=0.D0
C
        EDOTEL(3,3)=-YP*(EDOTEL(1,1)+EDOTEL(2,2))
        EDOTPL(3,3)=-(EDOTPL(1,1)+EDOTPL(2,2))
C
        EDOT(3,3)=EDOTPL(3,3)+EDOTEL(3,3)
        DE(4)=EDOT(3,3)/FACTOR
C
        CALL VECTOR(ITYPE,S0,SV,1.D0)
        CALL VECTOR(ITYPE,EDOTEL,DELAS,2.D0)
        CALL VECTOR(ITYPE,EDOTPL,DPLAS,2.D0)
        CALL VECTOR(ITYPE,EDOT,RDE,2.D0)
C
        CALL CONVER(PDIJKL,DEP,IFLAG,ITYPE)
C
        DO 105 K1=1,3
        CST=0.D0
        DO 110 K2=1,3
 110    CST=CST+DEP(K1,K2)*RDE(K2)
        WORK=WORK+(SV(K1)+0.5D0*CST)*DPLAS(K1)/DJAC
 105    SV(K1)=SV(K1)+CST+GVECT(K1)
        SV(4)=0.D0
C
        CALL TENSOR(ITYPE,SV,S0,1.D0)
C
        DO 115 K1=1,6
 115    STRELA(K1)=STRELA(K1)+DELAS(K1)
C
        IYIELD = 'Y'
      END IF
C
      IF (FACSUM.LT.1.) GO TO 34
C
C     CALCULATE DAMAGE VARIABLES
C
      CALL GDER(S0)
C
      CST1=0.D0
      DO 120 K1=1,3
      DO 120 K2=1,3
      CST1=CST1+GPHI(K1,K2)*GS(K1,K2)
 120  CONTINUE
C
      DO 125 K1=1,3
      DO 125 K2=1,3
 125  SD(K1,K2)=S0(K1,K2)-SS0(K1,K2)
C
      ABETA=0.D0
      DO 126 K1=1,3
      DO 126 K2=1,3
 126  ABETA=ABETA+GS(K1,K2)*SD(K1,K2)
      ABETA=ABETA/(DBBET-CST1)
C
      TABETA=TABETA+ABETA
C
      DO 140 K2=1,3
      DO 140 K1=1,3
      DDAMVA(K1,K2)=ABETA*GS(K1,K2)
 140  IF (DDAMVA(K1,K2).LT.0.) DDAMVA(K1,K2)=DABS(DDAMVA(K1,K2))
C
C     DDAMVA(3,3)=0.D0
      DDAMVA(1,3)=0.D0
      DDAMVA(3,1)=0.D0
      DDAMVA(3,2)=0.D0
      DDAMVA(2,3)=0.D0
C
      CALL VECTOR(300,DDAMVA,DPHI,1.D0)
C
      DO 145 K1=1,3
      DO 145 K2=1,3
  145 DAMVAR(K1,K2)=DAMVAR(K1,K2)+DDAMVA(K1,K2)
C
C     DAMVAR(3,3)=0.D0
      DAMVAR(1,3)=0.D0
      DAMVAR(3,1)=0.D0
      DAMVAR(3,2)=0.D0
      DAMVAR(2,3)=0.D0
C
      CALL VECTOR(300,DAMVAR,PHI,1.D0)
C
      DBCS=DBBET-CST1
      IF (DBCS.LT.0.0) THEN
        ICRK='Y'
        WRITE(6,2009) INCREM,ELNUM,INTGPN
        GO TO 900
      END IF
 2009 FORMAT(2X,'CRACK(DBCS<0.0): INCREM=',I4,2X,'ELNUM=',I4,2X,I2)
C
      PPHI1=(PHI(1)+PHI(2))*0.5D0
      PPHI2=(PHI(1)-PHI(2))*0.5D0
      PPHI3=PPHI2*PPHI2
      PPHI=PPHI1+DSQRT(PPHI3+PHI(4)*PHI(4))
C
      IF (ELNUM.EQ.15) THEN
        WRITE(6,2004) INCREM,INTGPN,PHI(1),PHI(2),PHI(4),PPHI,TABETA
      END IF
 2004 FORMAT(2X,'INCREM=',I4,2X,I2,2X,'PHI11=',F10.8,2X,'PHI22=',F10.8,
     $2X,'PHI12=',F10.8,2X,'PPHI=',F10.8,2X,'BETA=',F10.8)
C
C       DEFINE THE 'IYIEL' VECTOR FOR FUTURE PLOTTING
C
      IF (IYIELD.EQ.'Y') THEN
        ITEMP=IBSET(IYIEL(ELNUM),INTGPN)
        IYIEL(ELNUM)=ITEMP
      ELSE
        ITEMP=IBCLR(IYIEL(ELNUM),INTGPN)
        IYIEL(ELNUM)=ITEMP
      END IF
C
      DO 150 K1=1,3
 150  STRAIN(K1)=STRN(K1)
      STRN(4)=STRAIN(4)+DE(4)
      STRAIN(4)=STRN(4)
C
      CALL VECTOR(ITYPE,S0,STRS,1.D0)
      CALL VECTOR(ITYPE,S0,STRESS,1.D0)
      CALL VECTOR(ITYPE,Z,CENTER,1.D0)
C
      WRITE(LDEV2,1000) CSTRS,CSTRN,CSELA,CPHI,CCENT,CWORK,IYIELD,
     $ CTABET,CDPHI
C
  900 RETURN
C
C ================= E N T R Y    M I D A M 1 ==========================
C
      ENTRY MIDAM1(ELNUM,ITYPE,MATNUM,INTGPN,IFLAG,IOUT)
C
      IYIELD = ' '
      IF (INCREM.GT.1) THEN
        IF (NIT.EQ.1) THEN
          READ(LDEV1,1000) CSTRS,CSTRN,CSELA,CPHI,CCENT,CWORK,IYIELD,
     $    CTABET,CDPHI
        ELSE
          READ(LDEV2,1000) CSTRS,CSTRN,CSELA,CPHI,CCENT,CWORK,IYIELD,
     $    CTABET,CDPHI
        END IF
          BACKSPACE(UNIT=LDEV)
      END IF
C
C --- GET THE MATERIAL PARAMETERS
C
      BETA=P1X(MATNUM)
      C3=P1Y(MATNUM)
      SY=P1Z(MATNUM)
      DAMA=P3X(MATNUM)
      DBBET=P5X(MATNUM)
      YOUNG=EX(MATNUM)
      POISS=NUX(MATNUM)
C
C --- CALCULATION OF THE USEFULL MATRICES
C
      CALL TENSOR(ITYPE,STRESS,S0,1.D0)
      CALL TENSOR(ITYPE,STRAIN,E,0.5D0)
      CALL TENSOR(ITYPE,CENTER,Z,1.D0)
      CALL TENSOR(300,PHI,DAMVAR,1.D0)
C
      DO 200 K1=1,3
      DO 200 K2=1,3
 200  C(K1,K2)=2.D0*E(K1,K2)+DEL(K1,K2)
C
      IF (IYIELD.EQ.'Y') THEN
        CALL ADMAT(YOUNG,POISS)
        CALL JIJKL(DAMA)
C
C --- CALCULATION OF THE JACOBIAN OF DEFORMATION
C
        CALL DEFJAC(E,DEL,RR,DJAC)
C
C --- CALCULATION OF THE PARTIAL DERIVATIVE OF THE YIELD FUNCTION
C --- F WITH RESPECT TO THE <STRESS>,<STRAIN>, THE JACOBIAN.
C
        CALL AMIJK(PHI)
        CALL AMINV
        CALL MDPHI(PHI)
        CALL EFFSTR(S0,Z)
        CALL FDER(S0,TAU,C,ZA,DJAC,F1,F2,C3)
        CALL FBDER(C,DJAC,F1,F2,C3)
        CALL GDER(S0)
C
C --- CALCULATION OF THE ELASTOPLASTIC STIFFNESS MATRIX
C
        CALL ELPLD(SB,TB,ZAB,RR,DJAC,BETA)
        SCALE=1.0D0
        CALL XZIJKL(S0,Z,BETA,DPHI,SCALE)
        CALL XOIJK(S0,DBBET)
        CALL SYMMET(OIJKL)
        CALL TINVER(OIJKL,OII)
        CALL DEPMOD(ITYPE,IFLAG)
        CALL SYMMET(PDIJKL)
        CALL CONVER(PDIJKL,DEP,IFLAG,ITYPE)
      ELSE
        CALL ADMAT(YOUNG,POISS)
        CALL AMIJK(PHI)
        CALL AMINV
        CALL EDBAR
        CALL CONVER(EDIJKL,DEP,IFLAG,ITYPE)
C
        DO 333 I=1,6
 333    GVECT(I)=0.D0
C
       END IF
C
      RETURN
 1000 FORMAT(5A48,A8,A1,A8,A48)
      END
C
C ==================================================================
C I                     E F F S T R                                I
C ==================================================================
C
      SUBROUTINE EFFSTR(S0,Z)
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION S0(3,3),Z(3,3)
      DIMENSION XMRR(3,3),XDEL(3,3)
      COMMON/AMIJK1/XMIJKL(3,3,3,3)
      COMMON/EFFST1/XN(3,3,3,3),TAU(3,3),ZA(3,3),SB(3,3),TB(3,3),
     1     ZAB(3,3)
C
      PRESSURE=(S0(1,1)+S0(2,2)+S0(3,3))*0.3333333333333333333D0
      TAU(1,1)=S0(1,1)-PRESSURE
      TAU(2,2)=S0(2,2)-PRESSURE
      TAU(3,3)=S0(3,3)-PRESSURE
      TAU(1,2)=S0(1,2)
      TAU(2,1)=S0(1,2)
      TAU(1,3)=S0(1,3)
      TAU(3,1)=S0(1,3)
      TAU(2,3)=S0(2,3)
      TAU(3,2)=S0(2,3)
C
      ZPRESSRE=(Z(1,1)+Z(2,2)+Z(3,3))*0.3333333333333333333D0
      ZA(1,1)=Z(1,1)-ZPRESSRE
      ZA(2,2)=Z(2,2)-ZPRESSRE
      ZA(3,3)=Z(3,3)-ZPRESSRE
      ZA(1,2)=Z(1,2)
      ZA(2,1)=Z(1,2)
      ZA(1,3)=Z(1,3)
      ZA(3,1)=Z(1,3)
      ZA(2,3)=Z(2,3)
      ZA(3,2)=Z(2,3)
C
C EVALUATE THE KRONECKER DELTA SECOND-RANK TENSOR DELTA(I,J)
C
      XDEL(1,1)=1.D0
      XDEL(1,2)=0.D0
      XDEL(1,3)=0.D0
      XDEL(2,1)=0.D0
      XDEL(2,2)=1.D0
      XDEL(2,3)=0.D0
      XDEL(3,1)=0.D0
      XDEL(3,2)=0.D0
      XDEL(3,3)=1.D0
C
C EVALUATE THE CONTRACTION M(R,R,K,L)
C
      DO 10 K1=1,3
      DO 10 K2=1,3
      XMRR(K1,K2)=0.D0
      DO 10 K3=1,3
      XMRR(K1,K2)=XMRR(K1,K2)+XMIJKL(K3,K3,K1,K2)
   10 CONTINUE
C
C EVALUATE THE FOURTH-RANK TENSOR N(I,J,K,L)
C
      DO 20 I=1,3
      DO 20 J=1,3
      DO 20 K=1,3
      DO 20 L=1,3
      XN(I,J,K,L)=XMIJKL(I,J,K,L)-XMRR(K,L)*XDEL(I,J)/3.D0
   20 CONTINUE
C
C EVALUATE THE FOURTH-RANK TENSOR H(I,J,K,L)
C
C     DO 30 I=1,3
C     DO 30 J=1,3
C     DO 30 K=1,3
C     DO 30 L=1,3
C     XH(I,J,K,L)=0.D0
C     DO 30 K1=1,3
C     DO 30 K2=1,3
C     XH(I,J,K,L)=XH(I,J,K,L)+XN(K1,K2,I,J)+XN(K1,K2,K,L)
C  30 CONTINUE
C
      DO 40 I=1,3
      DO 40 J=1,3
      SB(I,J)=0.D0
      TB(I,J)=0.D0
      ZAB(I,J)=0.D0
      DO 40 K=1,3
      DO 40 L=1,3
      SB(I,J)=SB(I,J)+XMIJKL(I,J,K,L)*S0(K,L)
      TB(I,J)=TB(I,J)+XN(I,J,K,L)*S0(K,L)
      ZAB(I,J)=ZAB(I,J)+XN(I,J,K,L)*Z(K,L)
   40 CONTINUE
C
      RETURN
      END
C
C ====================================================================
C ========================= F B D E R ================================
C ====================================================================
C
      SUBROUTINE FBDER(C,DJAC,F1,F2,C3)
C
C ====================================================================
C I                                                                  I
C I       THIS PROGRAM CALCULATES THE DERIVATIVE OF "F" WRT          I
C I       <STRESS>, <STRAIN>, JACOBIAN, AND PLASTIC WORD WKC         I
C I                                                                  I
C I       F1S =  PARTIAL DERIVATIVE OF F1 WRT <STRESS>               I
C I       F2S =  PARTIAL DERIVATIVE OF F2 WRT <STRESS>               I
C I       F1E =  PARTIAL DERIVATIVE OF F1 WRT <STRAIN>               I
C I       F2E =  PARTIAL DERIVATIVE OF F2 WRT <STRAIN>               I
C I       F1J =  PARTIAL DERIVATIVE OF F1 WRT JACOBIAN               I
C I       F2J =  PARTIAL DERIVATIVE OF F2 WRT JACOBIAN               I
C I       F3J =  PARTIAL DERIVATIVE OF F3 WRT JACOBIAN               I
C I                                                                  I
C I       FOR THE DEFENITIONS OF F1,F2 REFER TO THE                  I
C I       SUBPROGTAM "YIELD".                                        I
C I                                                                  I
C I                                                                  I
C I       FS = DERIVATIVE OF F WRT <STRESS>                          I
C I       FE = DERIVATIVE OF F WRT <STRAIN>                          I
C I       FZ = DERIVATIVE OF F WRT <SHIFT TENSOR>                    I
C I       FK = DERIVATIVE OF F WRT WK                                I
C I       FJ = DERIVATIVE OF F WRT JACOBIAN                          I
C I                                                                  I
C I       FOR THE DEFENITION OF THE OTHER TERMS OR MATRICES REFER    I
C I       TO SUBPROGRAMS "JACOB" AND "MATRIC".                       I
C I                                                                  I
C ====================================================================
C
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON/FBDER1/FBJ,FBK,FBS(3,3),FBE(3,3),FBZ(3,3),FBT(3,3)
      COMMON/EFFST1/XN(3,3,3,3),TAU(3,3),ZA(3,3),SB(3,3),TB(3,3),
     1       ZAB(3,3)
      DIMENSION C(3,3)
C
      DJACO = 1.D0/DJAC**2
      CONST = 0.3333333333333333D0
C
      CST1 = 0.D0
      TST1 = 0.D0
      CST2 = 0.D0
      DO 10 K2 = 1 , 3
      DO 10 K1 = 1 , 3
      CST1 = CST1 + SB(K1 , K2)*C(K1 , K2)
      TST1 = CST1 + TB(K1 , K2)*C(K1 , K2)
  10  CST2 = CST2 + ZAB(K1 , K2)*C(K1 , K2)
C
      DO 30 K1 = 1 , 3
      DO 30 K2 = 1 , K1
      CST3 = 0.D0
      TST3 = 0.D0
      CST4 = 0.D0
      TST4 = 0.D0
      CST5 = 0.D0
      CST6 = 0.D0
      CST7 = 0.D0
      DO 20 K3 = 1 , 3
      DO 20 K4 = 1 , 3
      C34 = C(K3 , K4)
      CST3 = CST3 + SB(K3 , K1)*SB(K4 , K2)*C34
      CST4 = CST4 + C(K1 , K3)*C(K2 , K4)*SB(K3 , K4)
      TST4 = TST4 + C(K1 , K3)*C(K2 , K4)*TB(K3 , K4)
      CST5 = CST5 + ZAB(K3 , K1)*ZAB(K4 , K2)*C34
      CST6 = CST6 + SB(K3 , K1)*ZAB(K4 , K2)*C34
      CST7 = CST7 + C(K1 , K3)*C(K2 , K4)*ZAB(K3 , K4)
 20   CONTINUE
      C12 = C(K1 , K2)
      S12 = SB(K1 , K2)
      F1S = CST4 - CONST*CST1*C12
      F1T = TST4 - CONST*TST1*C12
      F1E = CST3 - CONST*CST1*S12
      F2S = CONST*CST2*C12 - CST7
      F2Z = CST7 - CST4 + CONST*(CST1 - CST2)*C12
      F2E = CST5 - 2.D0*CST6 + CONST*((CST1 - CST2)
     #      *ZAB(K1 , K2) + CST2*S12)
C
      FBS(K1,K2)=DJACO*(F1S + F2S)
      FBT(K1,K2)=DJACO*(F1T + F2S)
      FBE(K1,K2)=2.D0*DJACO*(F1E + F2E)
      FBZ(K1,K2)=F2Z*DJACO
      FBS(K2,K1)=FBS(K1 , K2)
      FBT(K2,K1)=FBT(K1 , K2)
      FBE(K2,K1)=FBE(K1 , K2)
      FBZ(K2,K1)=FBZ(K1 , K2)
 30   CONTINUE
C
      F1J=-2.D0*F1/DJAC
      F2J=-2.D0*F2/DJAC
      FBJ=F1J+F2J
      FBK=-C3
C
      RETURN
      END
C
C ===================================================================== 00518100
C ======================= X O I J K =================================== 00518200
C ===================================================================== 00518300
C                                                                       00518400
      SUBROUTINE XOIJK(S,DBBET)                                         00518500
C                                                                       00518600
C THIS SUBPROGRAM CALCULATES THE TENSOR O(I,J,K,L)                      00518700
C                                                                       00518800
      IMPLICIT REAL*8 (A-H,O-Z)                                         00518900
      COMMON/ELPLD1/DEPM(3,3,3,3)                                       00519000
      COMMON/EDBAR1/EDIJKL(3,3,3,3)                                     00519100
      COMMON/AMIJK1/XMIJKL(3,3,3,3)                                     00519200
      COMMON/AMINV1/XMTINV(3,3,3,3)                                     00519300
      COMMON/MDPHI1/XMPHI(3,3,3,3,3,3)                                  00519400
      COMMON/GDER1/GS(3,3),GPHI(3,3)                                    00519500
      COMMON/XOIJK1/OIJKL(3,3,3,3)                                      00519600
      COMMON/XZIJKL1/XIJKL(3,3,3,3),ZIJ(3,3)
      DIMENSION CST1(3,3,3,3),CST3(3,3,3,3,3,3),CST4(3,3,3,3)           00519700
      DIMENSION CST5(3,3,3,3,3,3),CST6(3,3,3,3,3,3)                     00519800
      DIMENSION CST7(3,3,3,3,3,3),CST8(3,3,3,3)                         00519900
      DIMENSION EINVB(3,3,3,3),CST10(3,3,3,3)                           00520000
      DIMENSION CST11(3,3,3,3),CST12(3,3,3,3),FRACT(3,3,3,3)            00520000
      DIMENSION S(3,3)                                                  00520000
C
      DO 10 K1=1,3                                                      00520200
      DO 10 K2=1,3                                                      00520300
      DO 10 K3=1,3                                                      00520400
      DO 10 K4=1,3                                                      00520500
      CST1(K1,K2,K3,K4)=GS(K1,K2)*GS(K3,K4)
   10 CONTINUE                                                          00520600
C                                                                       00520700
      CST2=0.D0
      DO 15 K1=1,3                                                      00520800
      DO 15 K2=1,3                                                      00520900
      CST2=CST2+GS(K1,K2)*GPHI(K1,K2)                                   00521100
   15 CONTINUE                                                          00521200
C
      DO 20 K1=1,3
      DO 20 K2=1,3
      DO 20 K3=1,3
      DO 20 K4=1,3
      FRACT(K1,K2,K3,K4)=CST1(K1,K2,K3,K4)/(DBBET-CST2)
  20  CONTINUE
C                                                                       00521300
      DO 25 K1=1,3                                                      00521400
      DO 25 K2=1,3                                                      00521500
      DO 25 K3=1,3                                                      00521600
      DO 25 K4=1,3                                                      00521700
      DO 25 K5=1,3                                                      00521800
      DO 25 K6=1,3                                                      00521900
      CST3(K1,K2,K3,K4,K5,K6)=0.D0
      DO 25 K7=1,3                                                      00522100
      DO 25 K8=1,3                                                      00522200
      CST3(K1,K2,K3,K4,K5,K6)=CST3(K1,K2,K3,K4,K5,K6)                   00522300
     $  +XMPHI(K1,K2,K3,K4,K7,K8)*FRACT(K5,K6,K7,K8)                    00522400
   25 CONTINUE                                                          00522500
C                                                                       00522700
      DO 30 K1=1,3                                                      00522800
      DO 30 K2=1,3                                                      00522900
      DO 30 K3=1,3                                                      00523100
      DO 30 K4=1,3                                                      00523200
      CST4(K1,K2,K3,K4)=0.D0                                            00523300
      DO 30 K5=1,3
      DO 30 K6=1,3
      CST4(K1,K2,K3,K4)=CST4(K1,K2,K3,K4)
     $     +CST3(K1,K2,K5,K6,K3,K4)*S(K5,K6)
   30 CONTINUE                                                          00523400
C                                                                       00523500
      DO 35 K1=1,3                                                      00523600
      DO 35 K2=1,3                                                      00523700
      DO 35 K3=1,3                                                      00523900
      DO 35 K4=1,3                                                      00524000
      DO 35 K5=1,3
      DO 35 K6=1,3
      CST5(K1,K2,K3,K4,K5,K6)=0.D0
      DO 35 K7=1,3
      DO 35 K8=1,3
      CST5(K1,K2,K3,K4,K5,K6)=CST5(K1,K2,K3,K4,K5,K6)                   00524100
     $   +XMTINV(K7,K8,K1,K2)*CST3(K7,K8,K3,K4,K5,K6)
   35 CONTINUE                                                          00524200
C                                                                       00524300
      DO 40 K1=1,3                                                      00525200
      DO 40 K2=1,3                                                      00525300
      DO 40 K3=1,3                                                      00525400
      DO 40 K4=1,3                                                      00525500
      DO 40 K5=1,3                                                      00525600
      DO 40 K6=1,3                                                      00525700
      CST6(K1,K2,K3,K4,K5,K6)=0.D0
      DO 40 K7=1,3
      DO 40 K8=1,3
      CST6(K1,K2,K3,K4,K5,K6)=CST6(K1,K2,K3,K4,K5,K6)                   00525800
     $  +CST5(K1,K2,K7,K8,K3,K4)*XMTINV(K7,K8,K5,K6)                    00525900
   40 CONTINUE                                                          00526000
C                                                                       00526100
      CALL TINVER(EDIJKL,EINVB)
C
      DO 55 K1=1,3                                                      00526200
      DO 55 K2=1,3                                                      00526300
      DO 55 K3=1,3                                                      00526400
      DO 55 K4=1,3                                                      00526500
      DO 55 K5=1,3
      DO 55 K6=1,3
      CST7(K1,K2,K3,K4,K5,K6)=0.D0
      DO 55 K7=1,3                                                      00526900
      DO 55 K8=1,3                                                      00527000
      CST7(K1,K2,K3,K4,K5,K6)=CST7(K1,K2,K3,K4,K5,K6)                   00527100
     $  +CST6(K1,K2,K3,K4,K7,K8)*EINVB(K5,K6,K7,K8)                     00527200
   55 CONTINUE                                                          00527300
C                                                                       00527500
      DO 60 K1=1,3                                                      00527700
      DO 60 K2=1,3                                                      00527800
      DO 60 K3=1,3                                                      00527900
      DO 60 K4=1,3                                                      00528000
      CST8(K1,K2,K3,K4)=0.D0
      DO 60 K5=1,3
      DO 60 K6=1,3
      CST8(K1,K2,K3,K4)=CST8(K1,K2,K3,K4)                               00528100
     $  +CST7(K1,K2,K3,K4,K5,K6)*S(K5,K6)
   60 CONTINUE                                                          00528200
C                                                                       00528300
C                                                                       00530700
      DO 70 K1=1,3
      DO 70 K2=1,3
      DO 70 K3=1,3
      DO 70 K4=1,3
      CST10(K1,K2,K3,K4)=0.D0
      CST11(K1,K2,K3,K4)=0.D0
      DO 70 K5=1,3
      DO 70 K6=1,3
      CST10(K1,K2,K3,K4)=CST10(K1,K2,K3,K4)
     $  +EINVB(K1,K2,K5,K6)*XIJKL(K3,K4,K5,K6)
      CST11(K1,K2,K3,K4)=CST11(K1,K2,K3,K4)
     $   +XMTINV(K1,K2,K5,K6)*EINVB(K3,K4,K5,K6)
   70 CONTINUE
C                                                                       00530800
      DO 75 K1=1,3
      DO 75 K2=1,3
      DO 75 K3=1,3
      DO 75 K4=1,3
      CST12(K1,K2,K3,K4)=0.D0
      DO 75 K5=1,3
      DO 75 K6=1,3
      CST12(K1,K2,K3,K4)=CST12(K1,K2,K3,K4)
     $  +DEPM(K1,K2,K5,K6)*(-CST11(K5,K6,K3,K4)+CST10(K5,K6,K3,K4)
     $  +CST8(K5,K6,K3,K4))
   75 CONTINUE
C
      DO 80 I=1,3                                                       00531500
      DO 80 J=1,3                                                       00531600
      DO 80 K=1,3                                                       00531700
      DO 80 L=1,3                                                       00531800
      OIJKL(I,J,K,L)=XMIJKL(I,J,K,L)+CST4(I,J,K,L)+CST12(I,J,K,L)       00532000
   80 CONTINUE                                                          00532100
C
      RETURN                                                            00532200
      END                                                               00532300
C
C
C =========================================================
C ==========   SUBROUTINE XZIJKL     ======================
C =========================================================
C
      SUBROUTINE XZIJKL(S,Z,BETA,DPHI,SCALE)
C
C THIS SUBPROGRAM CALCULATES THE TENSORS X(I,J,K,L) AND Z(I,J)
C
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON/AMIJK1/XMIJKL(3,3,3,3)
      COMMON/AMINV1/XMTINV(3,3,3,3)
      COMMON/MDPHI1/XMPHI(3,3,3,3,3,3)
      COMMON/GDER1/GS(3,3),GPHI(3,3)
      COMMON/XZIJKL1/XIJKL(3,3,3,3),ZIJ(3,3)
      COMMON/FDER1/FJ,FK,FS(3,3),FE(3,3),FZ(3,3),FT(3,3)
      COMMON/FBDER1/FBJ,FBK,FBS(3,3),FBE(3,3),FBZ(3,3),FBT(3,3)
      COMMON/ADMAT1/AD(3,3,3,3)
      COMMON/EDBAR1/EDIJKL(3,3,3,3)                                     00546800
      COMMON/EFFST1/XN(3,3,3,3),TAU(3,3),ZA(3,3),SB(3,3),TB(3,3),
     1     ZAB(3,3)
      DIMENSION S(3,3),Z(3,3),DPHI(6)
      DIMENSION SUM3(3,3),SUM4(3,3),SUM5(3,3),XMCOD(3,3,3,3)
      DIMENSION DDAMVA(3,3),SUM6(3,3,3,3),SUM7(3,3)
      DIMENSION XMCODI(3,3,3,3),SUM9(3,3)
      DIMENSION EDINV(3,3,3,3)
C
C EVALUATE THE PARAMETERS 'A1' AND 'A2'
C
      CSTB1=0.D0
      CST1=0.D0
      DO 10 I=1,3
      DO 10 J=1,3
      CSTB1=CSTB1+FBS(I,J)*FBS(I,J)
      CST1=CST1+FS(I,J)*FS(I,J)
   10 CONTINUE
C
      CSTB2=0.D0
      CST2=0.D0
      CSTB3=0.D0
      CST3=0.D0
      DO 15 I=1,3
      DO 15 J=1,3
      CSTB2=CSTB2+FBZ(I,J)*(TB(I,J)-ZAB(I,J))
      CST2=CST2+FZ(I,J)*(TAU(I,J)-ZA(I,J))
      CSTB3=CSTB3+(TB(I,J)-ZAB(I,J))*FBS(I,J)
   15 CST3=CST3+(TAU(I,J)-ZA(I,J))*FS(I,J)
C
      AA11=-(FK*DSQRT(CSTB1)+2000.D0*BETA*CSTB2*CSTB1/CSTB3)
      AA22=-(FK*DSQRT(CST1)+2000.D0*BETA*CST2*CST1/CST3)
C
C EVALUATE THE PARAMETER 'A3'
C
C CALCULATE THE DDAMVA
C
      CALL TENSOR(300,DPHI,DDAMVA,1.D0)
      CALL TINVER(EDIJKL,EDINV)
C
      DO 20 M=1,3
      DO 20 N=1,3
      SUM3(M,N)=0.D0
      SUM4(M,N)=0.D0
      DO 20 K=1,3
      DO 20 L=1,3
      SUM3(M,N)=SUM3(M,N)+FBT(K,L)*AD(K,L,M,N)
      SUM4(M,N)=SUM4(M,N)+S(K,L)*EDINV(K,L,M,N)
   20 CONTINUE
C
      DO 30 I=1,3
      DO 30 J=1,3
      DO 30 K=1,3
      DO 30 L=1,3
      XMCOD(I,J,K,L)=0.D0
      DO 30 M=1,3
      DO 30 N=1,3
      XMCOD(I,J,K,L)=XMCOD(I,J,K,L)+XMPHI(I,J,K,L,M,N)*DDAMVA(M,N)
   30 CONTINUE
C
      DO 35 K=1,3
      DO 35 L=1,3
      DO 35 M=1,3
      DO 35 N=1,3
      SUM6(K,L,M,N)=0.D0
      DO 35 I=1,3
      DO 35 J=1,3
      SUM6(K,L,M,N)=SUM6(K,L,M,N)+XMTINV(I,J,K,L)*XMCOD(I,J,M,N)
   35 CONTINUE
C
      DO 40 K=1,3
      DO 40 L=1,3
      DO 40 M=1,3
      DO 40 N=1,3
      XMCODI(K,L,M,N)=0.D0
      DO 40 I=1,3
      DO 40 J=1,3
      XMCODI(K,L,M,N)=XMCODI(K,L,M,N)+(SUM6(K,L,I,J)*XMTINV(I,J,M,N))
   40 CONTINUE
C
      DO 41 K=1,3
      DO 41 L=1,3
      DO 41 M=1,3
      DO 41 N=1,3
   41 XMCODI(K,L,M,N)=-XMCODI(K,L,M,N)
C
      DO 45 K=1,3
      DO 45 L=1,3
      SUM7(K,L)=0.D0
      DO 45 M=1,3
      DO 45 N=1,3
      SUM7(K,L)=SUM7(K,L)+(SUM3(M,N)*XMCODI(M,N,K,L))
   45 CONTINUE
C
      AA33=0.D0
      DO 50 M=1,3
      DO 50 N=1,3
      AA33=AA33+SUM7(M,N)*SUM4(M,N)
   50 CONTINUE
C
C EVALUATE THE REQUIRED TENSORS X(I,J,K,L) AND Z(I,J)
C
      DO 51 I=1,3
      DO 51 J=1,3
      DO 51 K=1,3
      DO 51 L=1,3
      XIJKL(I,J,K,L)=AA22*XMTINV(I,J,K,L)/AA11
   51 CONTINUE
C
      DO 53 I=1,3
      DO 53 J=1,3
      SUM9(I,J)=0.D0
      DO 53 K=1,3
      DO 53 L=1,3
      SUM9(I,J)=SUM9(I,J)+XN(I,J,K,L)*(S(K,L)-Z(K,L))
   53 CONTINUE
C
      DO 54 I=1,3
      DO 54 J=1,3
      ZIJ(I,J)=3.D0*AA33*SUM9(I,J)/AA11*SCALE
   54 CONTINUE
C
      ZIJ(1,2)=(ZIJ(1,2)+ZIJ(2,1))*0.5D0
C     ZIJ(2,1)=ZIJ(1,2)
C
      RETURN
      END
C
C =====================================================================
C ======================= TINVER ======================================
C =====================================================================
      SUBROUTINE TINVER(T,TI)
      REAL*8 T,TI,X
      DIMENSION T(3,3,3,3),TI(3,3,3,3),X(6,6)
      CALL SYMMET(T)
      CALL CONVTM(T,X)
      CALL AIINV(X)
      CALL CONVMT(X,TI)
      RETURN
      END
C
C
C ===================================================================== 00535500
C ======================= D E P M O D ================================= 00535600
C ===================================================================== 00535700
C                                                                       00535800
      SUBROUTINE DEPMOD(ITYPE,IFLAG)                                    00535900
C                                                                       00536000
C THIS SUBPROGRAM CALCULATES THE MODIFIED ELASTO-PLASTIC STIFFNESS      00536100
C MATRIX TO INCLUDE THE EFFECT OF DAMAGE                                00536200
C                                                                       00536300
      IMPLICIT REAL*8 (A-H,O-Z)                                         00536400
C     COMMON/AMINV1/XMTINV(3,3,3,3)                                     00536500
      COMMON/ELPLD1/DEPM(3,3,3,3)                                       00536600
      COMMON/XZIJKL1/XIJKL(3,3,3,3),ZIJ(3,3)                            00536700
      COMMON/TINVR1/OII(3,3,3,3)
      COMMON/DEPMD1/PDIJKL(3,3,3,3)
      COMMON/MATER2/GVECT(6)
      DIMENSION CST(3,3,3,3),CMT(6,6),ZV(6)
C
      DO 10 M=1,3
      DO 10 N=1,3
      DO 10 K=1,3
      DO 10 L=1,3
      CST(M,N,K,L)=0.D0
      DO 10 I=1,3
      DO 10 J=1,3
      CST(M,N,K,L)=CST(M,N,K,L)+OII(I,J,M,N)*DEPM(I,J,K,L)
   10 CONTINUE
C
      DO 20 I=1,3
      DO 20 J=1,3
      DO 20 M=1,3
      DO 20 N=1,3
      PDIJKL(I,J,M,N)=0.D0
      DO 20 K=1,3
      DO 20 L=1,3
      PDIJKL(I,J,M,N)=PDIJKL(I,J,M,N)+CST(I,J,K,L)*XIJKL(K,L,M,N)
   20 CONTINUE
C
      CALL SYMMET(CST)
      CALL CONVER(CST,CMT,IFLAG,ITYPE)
      CALL VECTOR(ITYPE,ZIJ,ZV,2.0D0)
C
      DO 30 K1=1,3
      CST1=0.D0
      DO 40 K2=1,3
  40  CST1=CST1+CMT(K1,K2)*ZV(K2)
  30  GVECT(K1)=CST1
      GVECT(4)=0.D0
      GVECT(5)=0.D0
      GVECT(6)=0.D0
C
      RETURN   
      END      
C        
C
C =====================================================================
C ========================= D E F J A C ===============================
C =====================================================================
C
      SUBROUTINE DEFJAC(E,DEL,RR,DJAC)
C
C ====================================================================
C I                                                                  I
C I        THIS SUBPROGRAM CALCULATES THE DETERMINANT OF THE         I
C I        DEFORMATION JACOBIAN AND THE <RR> MATRIX.                 I
C I                                                                  I
C I        EINV1     = FIRST STRAIN INVARIANT                        I
C I        EINV2     = SECOND STRAIN INVARIANT                       I
C I        EINV3     = THIRD STRAIN INVARIANT                        I
C I        DJAC      = DETERMINANT OF THE JACOBIAN                   I
C I        RR(K1 , K2) = THIS MATRIX WHEN DOTTED WITH THE STRAIN      I
C I                    TENSOR WILL RESULT THE INCREMENT OF THE       I
C I                    JACOBIAN.                                     I
C I                                                                  I
C ====================================================================
C
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION E(3,3),DEL(3,3),RR(3,3)

C --- CALCULATION OF THE STRAIN INVARIANTS

      EINV1 = 0.D0
      EINV2 = 0.D0
      EINV3 = 0.D0
C
      DO 10 K1=1,3
      EINV1=EINV1+E(K1,K1)
      DO 10 K2=1,3
      EINV2=EINV2+E(K1,K2)**2
      DO 10 K3=1,3
   10 EINV3=EINV3+E(K1,K2)*E(K2,K3)*E(K3,K1)
C
      EINV2 = 0.5D0*EINV2
      EINV3 = 0.3333333333333333D0*EINV3
C
C --- CALCULATION OF THE DEFORMATION JACOBIAN DETERMINANT
C
      C23 = 0.66666666666666666D0
      DJAC1=1.D0+2.D0*EINV1*(1.D0+EINV1+C23*EINV1**2)-
     #4.D0*EINV2*(1.D0+2.D0*EINV1)+8.D0*EINV3
      IF (DJAC1.LT.0.D0) THEN
      DJAC1=1.D0
      END IF
      DJAC = DJAC1**(0.5D0)
C
C --- CALCULATION OF THE MATRIX RR(K1 , K2)
C
      DO 30 K1=1,3
      DO 30 K2=1,K1
      CST1=0.D0
      DO 20 K3=1,3
  20  CST1 = CST1+E(K1,K3)*E(K3,K2)
      DELTA = DEL(K1,K2)
      RR(K1,K2)=2.D0*(DELTA*(EINV1-2.D0*EINV2+EINV1**2)-(1.D0
     #+2.D0*EINV1)*E(K1,K2)+2.D0*CST1+0.5D0*DELTA)/DJAC
      RR(K2,K1)=RR(K1,K2)
  30  CONTINUE
C
C     WRITE(6,100) DJAC
C 100 FORMAT(2X,'DJAC=',F30.5)
      RETURN
      END
C
C =====================================================================
C =========================== Y I E L D ===============================
C =====================================================================
C
      SUBROUTINE YIELD(S,C,Z,WORK,DJAC,C3,SY,F,F1,F2)
C
C =====================================================================
C I                                                                   I
C I    THIS SUBPROGRAM CALCULATES THE VALUE OF THE YIELD FUNCTION.    I
C I    THE PROGRAMED YIED FUNCTION IS AN EXTENDE FORM OF THE          I
C I    VON MISES YIELD CRITERION. THIS YIELD FUNCTION IS THE          I
C I    EQUIVALANT LAGRANGIAN FORMULATION OF THE EULERIAN VON MISES    I
C I    TYPE YIELD CRITERIA.                                           I
C I                                                                   I
C I    THE YIELD FUNCTION HAS THE FOLLOWING FORM.                     I
C I                                                                   I
C I        F = (F1)+(C2)(F2)+(C3)(F3)-AKEY**2                         I
C I                                                                   I
C I    C2        KINEMATIC WORK-HARDENING COEFFICIANT                 I
C I    C3        IS THE ISOTROPIC WORKHARDENING COEFICIANT            I
C I    SY        IS THE YIELD STRESS IN SIMPLE TENSION TEST           I
C I    F1        IS THE SECOUND EULERIAN STRESS TENSOR INVAR.         I
C I    F2        IS THE PART WHICK ACOUNTS FOR THE KINAMATIC WORK     I
C I                HARDENING.                                         I
C I    F3        IS THE PLASTIC WORK.                                 I
C I                                                                   I
C I    FOR DEFENITION OF THE OTHER TERMS AND MATRICES REFER TO THE    I
C I    SUBPROGRAMS "JACOB" AND "MATRIC".                              I
C I                                                                   I
C =====================================================================
C
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION S(3,3),C(3,3),Z(3,3)
C
      DJACO = 1.D0/DJAC**2
      CST1 = 0.D0
      CST2 = 0.D0
      CST3 = 0.D0
      CST4 = 0.D0
      CST5 = 0.D0
C
      DO 10 K2 = 1 , 3
      DO 10 K1 = 1 , 3
      CST1 = CST1+S(K1 , K2)*C(K1 , K2)
      CST2 = CST2+Z(K1 , K2)*C(K1 , K2)
      DO 10 K4 = 1 , 3
      DO 10 K3 = 1 , 3
      CST = C(K1 , K3)*C(K2 , K4)
      CST3 = CST3+S(K1 , K2)*S(K3 , K4)*CST
      CST4 = CST4+S(K1 , K2)*Z(K3 , K4)*CST
      CST5 = CST5+Z(K1 , K2)*Z(K3 , K4)*CST
  10  CONTINUE
C
      C13 = 0.3333333333333333D0
      C16 = 0.1666666666666666D0
      F1 = DJACO*(0.5D0*CST3-C16*CST1**2)
      F2 = DJACO*(C13*CST1*CST2-CST4+0.5D0*CST5-C16*CST2**2)
      F3 = -WORK
      F = F1+F2+C3*F3-SY**2
C
      RETURN
      END
C
C ====================================================================
C ======================== T R A N S T ===============================
C ====================================================================
C
      SUBROUTINE TRANST(S,Z,TAU,ZA)
      IMPLICIT REAL*8(A-H,O-Z)
      DIMENSION S(3,3),Z(3,3),TAU(3,3),ZA(3,3)
C
      PRESSURE=(S(1,1)+S(2,2)+S(3,3))*0.33333333333333333D0
      TAU(1,1)=S(1,1)-PRESSURE
      TAU(2,2)=S(2,2)-PRESSURE
      TAU(3,3)=S(3,3)-PRESSURE
      TAU(1,2)=S(1,2)
      TAU(2,1)=S(1,2)
      TAU(1,3)=S(1,3)
      TAU(3,1)=S(1,3)
      TAU(2,3)=S(2,3)
      TAU(3,2)=S(2,3)
C
      ZAPRESS=(Z(1,1)+Z(2,2)+Z(3,3))*0.33333333333333333D0
      ZA(1,1)=Z(1,1)-ZAPRESS
      ZA(2,2)=Z(2,2)-ZAPRESS
      ZA(3,3)=Z(3,3)-ZAPRESS
      ZA(1,2)=Z(1,2)
      ZA(2,1)=Z(1,2)
      ZA(1,3)=Z(1,3)
      ZA(3,1)=Z(1,3)
      ZA(2,3)=Z(2,3)
      ZA(3,2)=Z(2,3)
C
      RETURN
      END
C
C ====================================================================
C ========================= F D E R ==================================
C ====================================================================
C
      SUBROUTINE FDER(S,T,C,Z,DJAC,F1,F2,C3)
C
C ====================================================================
C I                                                                  I
C I       THIS PROGRAM CALCULATES THE DERIVATIVE OF "F" WRT          I
C I       <STRESS>, <STRAIN>, JACOBIAN, AND PLASTIC WORD WKC         I
C I                                                                  I
C I       F1S =  PARTIAL DERIVATIVE OF F1 WRT <STRESS>               I
C I       F2S =  PARTIAL DERIVATIVE OF F2 WRT <STRESS>               I
C I       F1E =  PARTIAL DERIVATIVE OF F1 WRT <STRAIN>               I
C I       F2E =  PARTIAL DERIVATIVE OF F2 WRT <STRAIN>               I
C I       F1J =  PARTIAL DERIVATIVE OF F1 WRT JACOBIAN               I
C I       F2J =  PARTIAL DERIVATIVE OF F2 WRT JACOBIAN               I
C I       F3J =  PARTIAL DERIVATIVE OF F3 WRT JACOBIAN               I
C I                                                                  I
C I       FOR THE DEFENITIONS OF F1,F2 REFER TO THE                  I
C I       SUBPROGTAM "YIELD".                                        I
C I                                                                  I
C I                                                                  I
C I       FS = DERIVATIVE OF F WRT <STRESS>                          I
C I       FE = DERIVATIVE OF F WRT <STRAIN>                          I
C I       FZ = DERIVATIVE OF F WRT <SHIFT TENSOR>                    I
C I       FK = DERIVATIVE OF F WRT WK                                I
C I       FJ = DERIVATIVE OF F WRT JACOBIAN                          I
C I                                                                  I
C I       FOR THE DEFENITION OF THE OTHER TERMS OR MATRICES REFER    I
C I       TO SUBPROGRAMS "JACOB" AND "MATRIC".                       I
C I                                                                  I
C ====================================================================
C
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON/FDER1/FJ,FK,FS(3,3),FE(3,3),FZ(3,3),FT(3,3)
      DIMENSION S(3,3),C(3,3),Z(3,3),T(3,3)
C
      DJACO = 1.D0/DJAC**2
      CONST = 0.3333333333333333D0
C
      CST1 = 0.D0
      TST1 = 0.D0
      CST2 = 0.D0
      DO 10 K2 = 1 , 3
      DO 10 K1 = 1 , 3
      CST1 = CST1 + S(K1 , K2)*C(K1 , K2)
      TST1 = CST1 + T(K1 , K2)*C(K1 , K2)
  10  CST2 = CST2 + Z(K1 , K2)*C(K1 , K2)
C
      DO 30 K1 = 1 , 3
      DO 30 K2 = 1 , K1
      CST3 = 0.D0
      TST3 = 0.D0
      CST4 = 0.D0
      TST4 = 0.D0
      CST5 = 0.D0
      CST6 = 0.D0
      CST7 = 0.D0
      DO 20 K3 = 1 , 3
      DO 20 K4 = 1 , 3
      C34 = C(K3 , K4)
      CST3 = CST3 + S(K3 , K1)*S(K4 , K2)*C34
      CST4 = CST4 + C(K1 , K3)*C(K2 , K4)*S(K3 , K4)
      TST4 = TST4 + C(K1 , K3)*C(K2 , K4)*T(K3 , K4)
      CST5 = CST5 + Z(K3 , K1)*Z(K4 , K2)*C34
      CST6 = CST6 + S(K3 , K1)*Z(K4 , K2)*C34
      CST7 = CST7 + C(K1 , K3)*C(K2 , K4)*Z(K3 , K4)
 20   CONTINUE
      C12 = C(K1 , K2)
      S12 = S(K1 , K2)
      F1S = CST4 - CONST*CST1*C12
      F1T = TST4 - CONST*TST1*C12
      F1E = CST3 - CONST*CST1*S12
      F2S = CONST*CST2*C12 - CST7
      F2Z = CST7 - CST4 + CONST*(CST1 - CST2)*C12
      F2E = CST5 - 2.D0*CST6 + CONST*((CST1 - CST2)
     #      *Z(K1 , K2) + CST2*S12)
C
      FS(K1,K2)=DJACO*(F1S + F2S)
      FT(K1,K2)=DJACO*(F1T + F2S)
      FE(K1,K2)=2.D0*DJACO*(F1E + F2E)
      FZ(K1,K2)=F2Z*DJACO
      FS(K2,K1)=FS(K1 , K2)
      FT(K2,K1)=FT(K1 , K2)
      FE(K2,K1)=FE(K1 , K2)
      FZ(K2,K1)=FZ(K1 , K2)
 30   CONTINUE
C
      F1J=-2.D0*F1/DJAC
      F2J=-2.D0*F2/DJAC
      FJ=F1J+F2J
      FK=-C3
C
      RETURN
      END
C
C =====================================================================
C ======================== E L P L D ==================================
C =====================================================================
C
      SUBROUTINE ELPLD(S,T,Z,RR,DJAC,BETA)
C
C =====================================================================
C I                                                                   I
C I        THIS PROGRAM CALCULATES THE ELASTOPLASTIC MATRIX           I
C I        THAT CORRESPONDS TO THE YIELD FUNCTION F                   I
C I                                                                   I
C =====================================================================


      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON/FBDER1/FBJ,FBK,FBS(3,3),FBE(3,3),FBZ(3,3),FBT(3,3)
      COMMON/FDER1/FJ,FK,FS(3,3),FE(3,3),FZ(3,3),FT(3,3)
      COMMON/ADMAT1/AD(3,3,3,3)
      COMMON/ELPLD1/DEPM(3,3,3,3)
      DIMENSION EFF(3,3),S(3,3),Z(3,3),RR(3,3),T(3,3)
      DIMENSION EFT(3,3),EFS(3,3),ED(3,3,3,3)
C
      D1=0.D0
      D2=0.D0
      D3=0.D0
      DEN1=0.D0
C
      DO 20 K1=1,3
      DO 20 K2=1,3
      EFF(K1,K2)=0.D0
      D1=D1+FBZ(K1,K2)*(T(K1,K2)-Z(K1,K2))
      D2=D2+FBS(K1,K2)**2
      D3=D3+(T(K1,K2)-Z(K1,K2))*FBS(K1,K2)
      DO 10 K3=1,3
      DO 10 K4=1,3
  10  EFF(K1,K2)=EFF(K1,K2)+AD(K3,K4,K1,K2)*FBT(K3,K4)
  20  DEN1=DEN1+EFF(K1,K2)*FBT(K1,K2)
C
      DEN=DEN1-DSQRT(D2)*FBK/DJAC-BETA*D1*D2/D3
C
      DO 30 M=1,3
      DO 30 N=1,3
      EFT(M,N)=0.D0
      DO 30 K=1,3
      DO 30 L=1,3
 30   EFT(M,N)=EFT(M,N)+FBT(K,L)*AD(K,L,M,N)
C
      DO 35 K=1,3
      DO 35 L=1,3
      EFS(K,L)=0.D0
      DO 35 I=1,3
      DO 35 J=1,3
 35   EFS(K,L)=EFS(K,L)+AD(K,L,I,J)*FBS(I,J)
C
      DO 40 K=1,3
      DO 40 L=1,3
      DO 40 M=1,3
      DO 40 N=1,3
 40   ED(K,L,M,N)=EFT(M,N)*EFS(K,L)
C
      DO 45 K=1,3
      DO 45 L=1,3
      DO 45 M=1,3
      DO 45 N=1,3
 45   DEPM(K,L,M,N)=AD(K,L,M,N)-DABS(ED(K,L,M,N)/DEN)
C
C
      RETURN
      END
C
C
C =====================================================================
C ======================== A L A M U ==================================
C =====================================================================
C
      SUBROUTINE ALAMU(S,T,Z,RR,DJAC,BETA)
C
C =====================================================================
C I                                                                   I
C I        THIS PROGRAM CALCULATES THE ELASTOPLASTIC MATRIX           I
C I        THAT CORRESPONDS TO THE YIELD FUNCTION F                   I
C I                                                                   I
C =====================================================================


      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON/FBDER1/FBJ,FBK,FBS(3,3),FBE(3,3),FBZ(3,3),FBT(3,3)
C     COMMON/FDER1/FJ,FK,FS(3,3),FE(3,3),FZ(3,3),FT(3,3)
      COMMON/EDBAR1/EDIJKL(3,3,3,3)
      COMMON/ALAMU1/ALAM(3,3),AMU(3,3)
      DIMENSION EFF(3,3),S(3,3),Z(3,3),RR(3,3),T(3,3)
      DIMENSION EFT(3,3),EFS(3,3),ED(3,3,3,3)
C
      D1=0.D0
      D2=0.D0
      D3=0.D0
      DEN1=0.D0
C
      DO 20 K1=1,3
      DO 20 K2=1,3
      EFF(K1,K2)=0.D0
      D1=D1+FBZ(K1,K2)*(T(K1,K2)-Z(K1,K2))
      D2=D2+FBS(K1,K2)**2
      D3=D3+(T(K1,K2)-Z(K1,K2))*FBS(K1,K2)
      DO 10 K3=1,3
      DO 10 K4=1,3
  10  EFF(K1,K2)=EFF(K1,K2)+EDIJKL(K3,K4,K1,K2)*FBT(K3,K4)
  20  DEN1=DEN1+EFF(K1,K2)*FBT(K1,K2)
C
      DEN=DEN1-DSQRT(D2)*FBK/DJAC-BETA*D1*D2/D3
C
      DO 30 K1=1,3
      DO 30 K2=1,K1
      ALAM(K1,K2)=(EFF(K1,K2)+FBE(K1,K2)+RR(K1,K2)*FBJ)/DEN
      AMU(K1,K2)=ALAM(K1,K2)*BETA*D2/D3
      ALAM(K2,K1)=ALAM(K1,K2)
      AMU(K2,K1)=AMU(K1,K2)
  30  CONTINUE
C
      RETURN
      END
C
